/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.table;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionAgent;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowRemovedCallback;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceVisitor;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.common.internal.epl.agg.table.AggregationServiceTable;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.table.core.TableColumnMethodPairEval;
import com.espertech.esper.common.internal.epl.table.core.TableEvalLockUtil;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceGrouped;
import com.espertech.esper.common.internal.event.core.ObjectArrayBackedEventBean;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Collection;

public abstract class AggSvcGroupByWTableBase
implements AggregationService,
AggregationServiceTable {
    protected final TableInstanceGrouped tableInstance;
    protected final TableColumnMethodPairEval[] methodPairs;
    private final AggregationMultiFunctionAgent[] accessAgents;
    private final int[] accessColumnsZeroOffset;
    protected AggregationRow currentAggregationRow;
    protected Object currentGroupKey;

    public AggSvcGroupByWTableBase(TableInstanceGrouped tableInstance, TableColumnMethodPairEval[] methodPairs, AggregationMultiFunctionAgent[] accessAgents, int[] accessColumnsZeroOffset) {
        this.tableInstance = tableInstance;
        this.methodPairs = methodPairs;
        this.accessAgents = accessAgents;
        this.accessColumnsZeroOffset = accessColumnsZeroOffset;
    }

    public abstract void applyEnterInternal(EventBean[] var1, Object var2, ExprEvaluatorContext var3);

    public abstract void applyLeaveInternal(EventBean[] var1, Object var2, ExprEvaluatorContext var3);

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        TableEvalLockUtil.obtainLockUnless(this.tableInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        this.applyEnterInternal(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        TableEvalLockUtil.obtainLockUnless(this.tableInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        this.applyLeaveInternal(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    void applyEnterGroupKey(EventBean[] eventsPerStream, Object groupByKeyUntransformed, ExprEvaluatorContext exprEvaluatorContext) {
        Object groupByKey = this.tableInstance.getTable().getPrimaryKeyIntoTableTransform().from(groupByKeyUntransformed);
        this.applyEnterTableKey(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    void applyLeaveGroupKey(EventBean[] eventsPerStream, Object groupByKeyUntransformed, ExprEvaluatorContext exprEvaluatorContext) {
        Object groupByKey = this.tableInstance.getTable().getPrimaryKeyIntoTableTransform().from(groupByKeyUntransformed);
        this.applyLeaveTableKey(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    @Override
    public void setCurrentAccess(Object groupByKeyUntransformed, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        Object groupByKey = this.tableInstance.getTable().getPrimaryKeyIntoTableTransform().from(groupByKeyUntransformed);
        ObjectArrayBackedEventBean bean = this.tableInstance.getRowForGroupKey(groupByKey);
        this.currentAggregationRow = bean != null ? (AggregationRow)bean.getProperties()[0] : null;
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.currentAggregationRow.getValue(column, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.currentAggregationRow.getCollectionOfEvents(column, eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.currentAggregationRow.getCollectionScalar(column, eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.currentAggregationRow.getEventBean(column, eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.tableInstance.getGroupKeys();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
    }

    @Override
    public void stop() {
    }

    @Override
    public AggregationService getContextPartitionAggregationService(int agentInstanceId) {
        return this;
    }

    @Override
    public TableInstance getTableInstance() {
        return this.tableInstance;
    }

    @Override
    public AggregationRow getAggregationRow(int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw new UnsupportedOperationException();
    }

    protected void applyEnterTableKey(EventBean[] eventsPerStream, Object tableKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ObjectArrayBackedEventBean bean = this.tableInstance.getCreateRowIntoTable(tableKey, exprEvaluatorContext);
        this.currentAggregationRow = (AggregationRow)bean.getProperties()[0];
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qAggregationGroupedApplyEnterLeave(true, this.methodPairs.length, this.accessAgents.length, tableKey);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPairEval methodPair = this.methodPairs[i];
            instrumentationCommon.qAggNoAccessEnterLeave(true, i, null, null);
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
            this.currentAggregationRow.enterAgg(methodPair.getColumn(), columnResult);
            instrumentationCommon.aAggNoAccessEnterLeave(true, i, null);
        }
        for (i = 0; i < this.accessAgents.length; ++i) {
            instrumentationCommon.qAggAccessEnterLeave(true, i, null);
            this.accessAgents[i].applyEnter(eventsPerStream, exprEvaluatorContext, this.currentAggregationRow, this.accessColumnsZeroOffset[i]);
            instrumentationCommon.aAggAccessEnterLeave(true, i);
        }
        this.tableInstance.handleRowUpdated(bean);
        instrumentationCommon.aAggregationGroupedApplyEnterLeave(true);
    }

    protected void applyLeaveTableKey(EventBean[] eventsPerStream, Object tableKey, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        ObjectArrayBackedEventBean bean = this.tableInstance.getCreateRowIntoTable(tableKey, exprEvaluatorContext);
        this.currentAggregationRow = (AggregationRow)bean.getProperties()[0];
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qAggregationGroupedApplyEnterLeave(false, this.methodPairs.length, this.accessAgents.length, tableKey);
        for (i = 0; i < this.methodPairs.length; ++i) {
            TableColumnMethodPairEval methodPair = this.methodPairs[i];
            instrumentationCommon.qAggNoAccessEnterLeave(false, i, null, null);
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, false, exprEvaluatorContext);
            this.currentAggregationRow.leaveAgg(methodPair.getColumn(), columnResult);
            instrumentationCommon.aAggNoAccessEnterLeave(false, i, null);
        }
        for (i = 0; i < this.accessAgents.length; ++i) {
            instrumentationCommon.qAggAccessEnterLeave(false, i, null);
            this.accessAgents[i].applyLeave(eventsPerStream, exprEvaluatorContext, this.currentAggregationRow, this.accessColumnsZeroOffset[i]);
            instrumentationCommon.aAggAccessEnterLeave(false, i);
        }
        this.tableInstance.handleRowUpdated(bean);
        instrumentationCommon.aAggregationGroupedApplyEnterLeave(false);
    }
}

