/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.compiletime;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.hook.aggfunc.ExtensionAggregationFunction;
import com.espertech.esper.common.client.hook.aggmultifunc.ExtensionAggregationMultiFunction;
import com.espertech.esper.common.client.hook.singlerowfunc.ExtensionSingleRowFunction;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedClasspathExtension;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedCompileTimeResolver;
import com.espertech.esper.common.internal.epl.classprovided.core.ClassProvided;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassProvidedClasspathExtensionImpl
implements ClassProvidedClasspathExtension {
    private final ClassProvidedCompileTimeResolver resolver;
    private final List<Class> classes = new ArrayList<Class>(2);
    private final Map<String, byte[]> bytes = new LinkedHashMap<String, byte[]>();
    private Map<String, Pair<Class, ExtensionSingleRowFunction>> singleRowFunctionExtensions = Collections.emptyMap();
    private Map<String, Pair<Class, ExtensionAggregationFunction>> aggregationFunctionExtensions = Collections.emptyMap();
    private Map<String, Pair<Class, String[]>> aggregationMultiFunctionExtensions = Collections.emptyMap();

    public ClassProvidedClasspathExtensionImpl(ClassProvidedCompileTimeResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void add(List<Class> classes, Map<String, byte[]> bytes) throws ExprValidationException {
        this.classes.addAll(classes);
        this.bytes.putAll(bytes);
        try {
            JavaClassHelper.traverseAnnotations(classes, ExtensionSingleRowFunction.class, (clazz, annotation) -> {
                if (this.singleRowFunctionExtensions.isEmpty()) {
                    this.singleRowFunctionExtensions = new HashMap<String, Pair<Class, ExtensionSingleRowFunction>>(2);
                }
                if (this.singleRowFunctionExtensions.containsKey(annotation.name())) {
                    throw new EPException("The plug-in single-row function '" + annotation.name() + "' occurs multiple times");
                }
                this.singleRowFunctionExtensions.put(annotation.name(), new Pair<Class, ExtensionSingleRowFunction>((Class)clazz, (ExtensionSingleRowFunction)annotation));
            });
            JavaClassHelper.traverseAnnotations(classes, ExtensionAggregationFunction.class, (clazz, annotation) -> {
                if (this.aggregationFunctionExtensions.isEmpty()) {
                    this.aggregationFunctionExtensions = new HashMap<String, Pair<Class, ExtensionAggregationFunction>>(2);
                }
                if (this.aggregationFunctionExtensions.containsKey(annotation.name())) {
                    throw new EPException("The plug-in aggregation function '" + annotation.name() + "' occurs multiple times");
                }
                this.aggregationFunctionExtensions.put(annotation.name(), new Pair<Class, ExtensionAggregationFunction>((Class)clazz, (ExtensionAggregationFunction)annotation));
            });
            JavaClassHelper.traverseAnnotations(classes, ExtensionAggregationMultiFunction.class, (clazz, annotation) -> {
                if (this.aggregationMultiFunctionExtensions.isEmpty()) {
                    this.aggregationMultiFunctionExtensions = new HashMap<String, Pair<Class, String[]>>(2);
                }
                String[] names = annotation.names().split(",");
                HashSet<String> namesDeduplicated = new HashSet<String>(names.length);
                for (String nameWithSpaces : names) {
                    String name = nameWithSpaces.trim();
                    namesDeduplicated.add(name);
                }
                String[] namesArray = namesDeduplicated.toArray(new String[0]);
                for (String name : namesDeduplicated) {
                    if (this.aggregationMultiFunctionExtensions.containsKey(name)) {
                        throw new EPException("The plug-in aggregation multi-function '" + name + "' occurs multiple times");
                    }
                    this.aggregationMultiFunctionExtensions.put(name, new Pair<Class, String[]>((Class)clazz, namesArray));
                }
            });
        }
        catch (EPException ex) {
            throw new ExprValidationException(ex.getMessage(), ex);
        }
    }

    @Override
    public Class findClassByName(String className) {
        Class clazz = this.resolve(className);
        if (clazz != null) {
            return clazz;
        }
        return this.resolve("generated." + className);
    }

    @Override
    public Pair<Class, ClasspathImportSingleRowDesc> resolveSingleRow(String name) {
        Pair<Class, ExtensionSingleRowFunction> pair = this.singleRowFunctionExtensions.get(name);
        if (pair != null) {
            return new Pair<Class, ClasspathImportSingleRowDesc>(pair.getFirst(), new ClasspathImportSingleRowDesc(pair.getFirst(), pair.getSecond()));
        }
        return this.resolver.resolveSingleRow(name);
    }

    @Override
    public Class resolveAggregationFunction(String name) {
        Pair<Class, ExtensionAggregationFunction> pair = this.aggregationFunctionExtensions.get(name);
        if (pair != null) {
            return pair.getFirst();
        }
        return this.resolver.resolveAggregationFunction(name);
    }

    @Override
    public Pair<Class, String[]> resolveAggregationMultiFunction(String name) {
        Pair<Class, String[]> pair = this.aggregationMultiFunctionExtensions.get(name);
        if (pair != null) {
            return pair;
        }
        return this.resolver.resolveAggregationMultiFunction(name);
    }

    @Override
    public Map<String, byte[]> getBytes() {
        return this.bytes;
    }

    @Override
    public boolean isLocalInlinedClass(Class<?> declaringClass) {
        for (Class clazz : this.classes) {
            if (declaringClass != clazz) continue;
            return true;
        }
        return false;
    }

    private Class resolve(String className) {
        for (Class clazz : this.classes) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        ClassProvided provided = this.resolver.resolveClass(className);
        if (provided != null) {
            for (Class clazz : provided.getClassesMayNull()) {
                if (!clazz.getName().equals(className)) continue;
                return clazz;
            }
        }
        return null;
    }
}

