/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.ops;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.common.client.dataflow.util.DataFlowParameterValidation;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeResult;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.dataflow.util.GraphTypeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;

public class FilterForge
implements DataFlowOperatorForge {
    @DataFlowOpParameter
    private ExprNode filter;
    private EventType eventType;
    private boolean singleOutputPort;

    @Override
    public DataFlowOpForgeInitializeResult initializeForge(DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (context.getInputPorts().size() != 1) {
            throw new ExprValidationException("Filter requires single input port");
        }
        if (this.filter == null) {
            throw new ExprValidationException("Required parameter 'filter' providing the filter expression is not provided");
        }
        if (context.getOutputPorts().isEmpty() || context.getOutputPorts().size() > 2) {
            throw new IllegalArgumentException("Filter operator requires one or two output stream(s) but produces " + context.getOutputPorts().size() + " streams");
        }
        this.eventType = context.getInputPorts().get(0).getTypeDesc().getEventType();
        this.singleOutputPort = context.getOutputPorts().size() == 1;
        this.filter = DataFlowParameterValidation.validate("filter", this.filter, this.eventType, Boolean.class, context);
        GraphTypeDesc[] typesPerPort = new GraphTypeDesc[context.getOutputPorts().size()];
        for (int i = 0; i < typesPerPort.length; ++i) {
            typesPerPort[i] = new GraphTypeDesc(false, true, this.eventType);
        }
        return new DataFlowOpForgeInitializeResult(typesPerPort);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return new SAIFFInitializeBuilder("com.espertech.esper.runtime.internal.dataflow.op.filter.FilterFactory", this.getClass(), "filter", parent, symbols, classScope).exprnode("filter", this.filter).eventtype("eventType", this.eventType).constant("singleOutputPort", this.singleOutputPort).build();
    }
}

