/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import java.io.StringWriter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public enum CalendarFieldEnum {
    MILLISEC(14, "msec,millisecond,milliseconds", ChronoField.MILLI_OF_SECOND, ChronoUnit.MILLIS),
    SECOND(13, "sec,second,seconds", ChronoField.SECOND_OF_MINUTE, ChronoUnit.SECONDS),
    MINUTE(12, "min,minute,minutes", ChronoField.MINUTE_OF_HOUR, ChronoUnit.MINUTES),
    HOUR(11, "hour,hours", ChronoField.HOUR_OF_DAY, ChronoUnit.HOURS),
    DAY(5, "day,days", ChronoField.DAY_OF_MONTH, ChronoUnit.DAYS),
    MONTH(2, "month,months", ChronoField.MONTH_OF_YEAR, ChronoUnit.MONTHS),
    WEEK(3, "week,weeks", ChronoField.ALIGNED_WEEK_OF_YEAR, ChronoUnit.WEEKS),
    YEAR(1, "year,years", ChronoField.YEAR, ChronoUnit.YEARS);

    private final int calendarField;
    private final String[] names;
    private final ChronoField chronoField;
    private final ChronoUnit chronoUnit;

    private CalendarFieldEnum(int calendarField, String names, ChronoField chronoField, ChronoUnit chronoUnit) {
        this.calendarField = calendarField;
        this.names = names.split(",");
        this.chronoField = chronoField;
        this.chronoUnit = chronoUnit;
    }

    public static String getValidList() {
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (CalendarFieldEnum v : CalendarFieldEnum.values()) {
            for (String name : v.names) {
                writer.append(delimiter);
                writer.append(name);
                delimiter = ",";
            }
        }
        return writer.toString();
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public String[] getNames() {
        return this.names;
    }

    public ChronoUnit getChronoUnit() {
        return this.chronoUnit;
    }

    public static CalendarFieldEnum fromString(String field) {
        String compareTo = field.trim().toLowerCase(Locale.ENGLISH);
        for (CalendarFieldEnum v : CalendarFieldEnum.values()) {
            for (String name : v.names) {
                if (!name.equals(compareTo)) continue;
                return v;
            }
        }
        return null;
    }

    public ChronoField getChronoField() {
        return this.chronoField;
    }
}

