/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatFormatForgeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class CalendarOpUtil {
    protected static Integer getInt(ExprEvaluator expr, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = expr.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return (Integer)result;
    }

    public static CalendarFieldEnum getEnum(String methodName, ExprNode exprNode) throws ExprValidationException {
        String message = CalendarOpUtil.validateConstant(methodName, exprNode);
        if (message != null) {
            message = message + ", " + CalendarOpUtil.getValidFieldNamesMessage();
            throw new ExprValidationException(message);
        }
        String fieldname = (String)exprNode.getForge().getExprEvaluator().evaluate(null, true, null);
        CalendarFieldEnum fieldNum = CalendarFieldEnum.fromString(fieldname);
        if (fieldNum == null) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " datetime-field name '" + fieldname + "' is not recognized, " + CalendarOpUtil.getValidFieldNamesMessage());
        }
        return fieldNum;
    }

    public static ReformatFormatForgeDesc validateGetFormatterType(EPChainableType inputType, String methodName, ExprNode exprNode) throws ExprValidationException {
        if (!(inputType instanceof EPChainableTypeClass)) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " requires a datetime input value but received " + inputType);
        }
        if (!exprNode.getForge().getForgeConstantType().isConstant()) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " requires a constant-value format");
        }
        ExprForge formatForge = exprNode.getForge();
        EPType formatType = formatForge.getEvaluationType();
        if (formatType == null || formatType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid null format object");
        }
        EPTypeClass formatClass = (EPTypeClass)formatType;
        Object format = null;
        if (formatForge.getForgeConstantType().isCompileTimeConstant() && (format = ExprNodeUtilityEvaluate.evaluateValidationTimeNoStreams(exprNode.getForge().getExprEvaluator(), null, "date format")) == null) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid null format object");
        }
        EPChainableTypeClass input = (EPChainableTypeClass)inputType;
        Class<?> inputTypeClass = input.getType().getType();
        if (JavaClassHelper.getBoxedType(input.getType().getType()) == Long.class || JavaClassHelper.isSubclassOrImplementsInterface(inputTypeClass, Date.class) || JavaClassHelper.isSubclassOrImplementsInterface(inputTypeClass, Calendar.class)) {
            if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)formatClass, DateFormat.class)) {
                return new ReformatFormatForgeDesc(false, DateFormat.class);
            }
            if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)formatClass, String.class)) {
                if (format != null) {
                    try {
                        new SimpleDateFormat((String)format);
                    }
                    catch (RuntimeException ex) {
                        throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format string (SimpleDateFormat): " + ex.getMessage(), ex);
                    }
                }
                return new ReformatFormatForgeDesc(false, String.class);
            }
            throw CalendarOpUtil.getFailedExpected(methodName, DateFormat.class, formatClass.getType());
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)formatClass, DateTimeFormatter.class)) {
            return new ReformatFormatForgeDesc(true, DateTimeFormatter.class);
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)formatClass, String.class)) {
            if (format != null) {
                try {
                    DateTimeFormatter.ofPattern((String)format);
                }
                catch (RuntimeException ex) {
                    throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format string (DateTimeFormatter): " + ex.getMessage(), ex);
                }
            }
            return new ReformatFormatForgeDesc(true, String.class);
        }
        throw CalendarOpUtil.getFailedExpected(methodName, DateTimeFormatter.class, formatClass.getType());
    }

    private static ExprValidationException getFailedExpected(String methodName, Class expected, Class received) {
        return new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format, expected string-format or " + expected.getSimpleName() + " but received " + ClassHelperPrint.getClassNameFullyQualPretty(received));
    }

    private static String validateConstant(String methodName, ExprNode exprNode) {
        if (ExprNodeUtilityQuery.isConstant(exprNode)) {
            return null;
        }
        return CalendarOpUtil.getMessage(methodName) + " requires a constant string-type parameter as its first parameter";
    }

    private static String getMessage(String methodName) {
        return "Date-time enumeration method '" + methodName + "'";
    }

    private static String getValidFieldNamesMessage() {
        return "valid field names are '" + CalendarFieldEnum.getValidList() + "'";
    }
}

