/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarPlusMinusForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;

public class CalendarPlusMinusForgeOp
implements CalendarOp {
    private final ExprEvaluator param;
    private final int factor;

    public CalendarPlusMinusForgeOp(ExprEvaluator param, int factor) {
        this.param = param;
        this.factor = factor;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object value = this.param.evaluate(eventsPerStream, isNewData, context);
        if (value instanceof Number) {
            CalendarPlusMinusForgeOp.actionCalendarPlusMinusNumber(cal, this.factor, ((Number)value).longValue());
        } else {
            CalendarPlusMinusForgeOp.actionCalendarPlusMinusTimePeriod(cal, this.factor, (TimePeriod)value);
        }
    }

    public static CodegenExpression codegenCalendar(CalendarPlusMinusForge forge, CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass evaluationType = (EPTypeClass)forge.param.getEvaluationType();
        if (JavaClassHelper.isNumeric(evaluationType)) {
            CodegenExpression longDuration = SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope), evaluationType);
            return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionCalendarPlusMinusNumber", cal, CodegenExpressionBuilder.constant(forge.factor), longDuration);
        }
        return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionCalendarPlusMinusTimePeriod", cal, CodegenExpressionBuilder.constant(forge.factor), forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope));
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object value = this.param.evaluate(eventsPerStream, isNewData, context);
        if (value instanceof Number) {
            return CalendarPlusMinusForgeOp.actionLDTPlusMinusNumber(ldt, this.factor, ((Number)value).longValue());
        }
        return CalendarPlusMinusForgeOp.actionLDTPlusMinusTimePeriod(ldt, this.factor, (TimePeriod)value);
    }

    public static CodegenExpression codegenLDT(CalendarPlusMinusForge forge, CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass evaluationType = (EPTypeClass)forge.param.getEvaluationType();
        if (JavaClassHelper.isNumeric(evaluationType)) {
            CodegenExpression longDuration = SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLongMayNullBox(forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope), evaluationType, codegenMethodScope, codegenClassScope);
            return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionLDTPlusMinusNumber", ldt, CodegenExpressionBuilder.constant(forge.factor), longDuration);
        }
        return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionLDTPlusMinusTimePeriod", ldt, CodegenExpressionBuilder.constant(forge.factor), forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope));
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object value = this.param.evaluate(eventsPerStream, isNewData, context);
        if (value instanceof Number) {
            return CalendarPlusMinusForgeOp.actionZDTPlusMinusNumber(zdt, this.factor, ((Number)value).longValue());
        }
        return CalendarPlusMinusForgeOp.actionZDTPlusMinusTimePeriod(zdt, this.factor, (TimePeriod)value);
    }

    public static CodegenExpression codegenZDT(CalendarPlusMinusForge forge, CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass evaluationType = (EPTypeClass)forge.param.getEvaluationType();
        if (JavaClassHelper.isNumeric(evaluationType)) {
            CodegenExpression longDuration = SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLongMayNullBox(forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope), evaluationType, codegenMethodScope, codegenClassScope);
            return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionZDTPlusMinusNumber", zdt, CodegenExpressionBuilder.constant(forge.factor), longDuration);
        }
        return CodegenExpressionBuilder.staticMethod(CalendarPlusMinusForgeOp.class, "actionZDTPlusMinusTimePeriod", zdt, CodegenExpressionBuilder.constant(forge.factor), forge.param.evaluateCodegen(evaluationType, codegenMethodScope, exprSymbol, codegenClassScope));
    }

    public static void actionCalendarPlusMinusNumber(Calendar cal, int factor, Long duration) {
        if (duration == null) {
            return;
        }
        if (duration < Integer.MAX_VALUE) {
            cal.add(14, (int)((long)factor * duration));
            return;
        }
        int days = (int)(duration / 86400000L);
        int msec = (int)(duration - (long)days * 86400000L);
        cal.add(14, factor * msec);
        cal.add(5, factor * days);
    }

    public static LocalDateTime actionLDTPlusMinusNumber(LocalDateTime ldt, int factor, Long duration) {
        if (duration == null) {
            return ldt;
        }
        if (duration < Integer.MAX_VALUE) {
            return ldt.plus((long)factor * duration, ChronoUnit.MILLIS);
        }
        int days = (int)(duration / 86400000L);
        int msec = (int)(duration - (long)days * 86400000L);
        ldt = ldt.plus(factor * msec, ChronoUnit.MILLIS);
        return ldt.plus(factor * days, ChronoUnit.DAYS);
    }

    public static ZonedDateTime actionZDTPlusMinusNumber(ZonedDateTime zdt, int factor, Long duration) {
        if (duration == null) {
            return zdt;
        }
        if (duration < Integer.MAX_VALUE) {
            return zdt.plus((long)factor * duration, ChronoUnit.MILLIS);
        }
        int days = (int)(duration / 86400000L);
        int msec = (int)(duration - (long)days * 86400000L);
        zdt = zdt.plus(factor * msec, ChronoUnit.MILLIS);
        return zdt.plus(factor * days, ChronoUnit.DAYS);
    }

    public static void actionSafeOverflow(Calendar cal, int factor, TimePeriod tp) {
        if (Math.abs(factor) == 1) {
            CalendarPlusMinusForgeOp.actionCalendarPlusMinusTimePeriod(cal, factor, tp);
            return;
        }
        Integer max = tp.largestAbsoluteValue();
        if (max == null || max == 0) {
            return;
        }
        CalendarPlusMinusForgeOp.actionHandleOverflow(cal, factor, tp, max);
    }

    public static void actionCalendarPlusMinusTimePeriod(Calendar cal, int factor, TimePeriod tp) {
        if (tp == null) {
            return;
        }
        if (tp.getYears() != null) {
            cal.add(1, factor * tp.getYears());
        }
        if (tp.getMonths() != null) {
            cal.add(2, factor * tp.getMonths());
        }
        if (tp.getWeeks() != null) {
            cal.add(3, factor * tp.getWeeks());
        }
        if (tp.getDays() != null) {
            cal.add(5, factor * tp.getDays());
        }
        if (tp.getHours() != null) {
            cal.add(11, factor * tp.getHours());
        }
        if (tp.getMinutes() != null) {
            cal.add(12, factor * tp.getMinutes());
        }
        if (tp.getSeconds() != null) {
            cal.add(13, factor * tp.getSeconds());
        }
        if (tp.getMilliseconds() != null) {
            cal.add(14, factor * tp.getMilliseconds());
        }
    }

    public static LocalDateTime actionLDTPlusMinusTimePeriod(LocalDateTime ldt, int factor, TimePeriod tp) {
        if (tp == null) {
            return ldt;
        }
        if (tp.getYears() != null) {
            ldt = ldt.plus(factor * tp.getYears(), ChronoUnit.YEARS);
        }
        if (tp.getMonths() != null) {
            ldt = ldt.plus(factor * tp.getMonths(), ChronoUnit.MONTHS);
        }
        if (tp.getWeeks() != null) {
            ldt = ldt.plus(factor * tp.getWeeks(), ChronoUnit.WEEKS);
        }
        if (tp.getDays() != null) {
            ldt = ldt.plus(factor * tp.getDays(), ChronoUnit.DAYS);
        }
        if (tp.getHours() != null) {
            ldt = ldt.plus(factor * tp.getHours(), ChronoUnit.HOURS);
        }
        if (tp.getMinutes() != null) {
            ldt = ldt.plus(factor * tp.getMinutes(), ChronoUnit.MINUTES);
        }
        if (tp.getSeconds() != null) {
            ldt = ldt.plus(factor * tp.getSeconds(), ChronoUnit.SECONDS);
        }
        if (tp.getMilliseconds() != null) {
            ldt = ldt.plus(factor * tp.getMilliseconds(), ChronoUnit.MILLIS);
        }
        return ldt;
    }

    public static ZonedDateTime actionZDTPlusMinusTimePeriod(ZonedDateTime zdt, int factor, TimePeriod tp) {
        if (tp == null) {
            return zdt;
        }
        if (tp.getYears() != null) {
            zdt = zdt.plus(factor * tp.getYears(), ChronoUnit.YEARS);
        }
        if (tp.getMonths() != null) {
            zdt = zdt.plus(factor * tp.getMonths(), ChronoUnit.MONTHS);
        }
        if (tp.getWeeks() != null) {
            zdt = zdt.plus(factor * tp.getWeeks(), ChronoUnit.WEEKS);
        }
        if (tp.getDays() != null) {
            zdt = zdt.plus(factor * tp.getDays(), ChronoUnit.DAYS);
        }
        if (tp.getHours() != null) {
            zdt = zdt.plus(factor * tp.getHours(), ChronoUnit.HOURS);
        }
        if (tp.getMinutes() != null) {
            zdt = zdt.plus(factor * tp.getMinutes(), ChronoUnit.MINUTES);
        }
        if (tp.getSeconds() != null) {
            zdt = zdt.plus(factor * tp.getSeconds(), ChronoUnit.SECONDS);
        }
        if (tp.getMilliseconds() != null) {
            zdt = zdt.plus(factor * tp.getMilliseconds(), ChronoUnit.MILLIS);
        }
        return zdt;
    }

    private static void actionHandleOverflow(Calendar cal, int factor, TimePeriod tp, int max) {
        if (max != 0 && factor > Integer.MAX_VALUE / max) {
            int first = factor / 2;
            int second = factor - first * 2 + first;
            CalendarPlusMinusForgeOp.actionHandleOverflow(cal, first, tp, max);
            CalendarPlusMinusForgeOp.actionHandleOverflow(cal, second, tp, max);
        } else {
            CalendarPlusMinusForgeOp.actionCalendarPlusMinusTimePeriod(cal, factor, tp);
        }
    }
}

