/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.dtlocal;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsDateForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluator;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsCalBase;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DTLocalCalOpsDateEval
extends DTLocalEvaluatorCalOpsCalBase
implements DTLocalEvaluator {
    private final TimeZone timeZone;

    public DTLocalCalOpsDateEval(List<CalendarOp> calendarOps, TimeZone timeZone) {
        super(calendarOps);
        this.timeZone = timeZone;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Date dateValue = (Date)target;
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(dateValue.getTime());
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        return cal.getTime();
    }

    public static CodegenExpression codegen(DTLocalCalOpsDateForge forge, CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.DATE.getEPType(), DTLocalCalOpsDateEval.class, (CodegenScope)codegenClassScope).addParam(innerType, "target");
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("target"), "getTime", new CodegenExpression[0])));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTime", new CodegenExpression[0]));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }
}

