/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.dtlocal;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsIntervalBase;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class DTLocalLongOpsIntervalEval
extends DTLocalEvaluatorCalOpsIntervalBase {
    private final TimeZone timeZone;
    private final TimeAbacus timeAbacus;

    public DTLocalLongOpsIntervalEval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone, TimeAbacus timeAbacus) {
        super(calendarOps, intervalOp);
        this.timeZone = timeZone;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        long startRemainder = this.timeAbacus.calendarSet((Long)target, cal);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long time = this.timeAbacus.calendarGet(cal, startRemainder);
        return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenPointInTime(DTLocalLongOpsIntervalForge forge, CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), DTLocalLongOpsIntervalEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "target");
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "startRemainder", forge.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "time", forge.timeAbacus.calendarGetCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("startRemainder"), codegenClassScope)).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        long startLong = (Long)startTimestamp;
        long endLong = (Long)endTimestamp;
        Calendar cal = Calendar.getInstance(this.timeZone);
        long startRemainder = this.timeAbacus.calendarSet(startLong, cal);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long startTime = this.timeAbacus.calendarGet(cal, startRemainder);
        long endTime = startTime + (endLong - startLong);
        return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenStartEnd(DTLocalLongOpsIntervalForge forge, CodegenExpressionRef start, CodegenExpressionRef end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), DTLocalLongOpsIntervalEval.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "startLong").addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "endLong");
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.CALENDAR.getEPType(), "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", timeZoneField)).declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "startRemainder", forge.timeAbacus.calendarSetCodegen(CodegenExpressionBuilder.ref("startLong"), CodegenExpressionBuilder.ref("cal"), methodNode, codegenClassScope));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "startTime", forge.timeAbacus.calendarGetCodegen(CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("startRemainder"), codegenClassScope)).declareVar(EPTypePremade.LONGPRIMITIVE.getEPType(), "endTime", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("startTime"), "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("endLong"), "-", CodegenExpressionBuilder.ref("startLong")))).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("startTime"), CodegenExpressionBuilder.ref("endTime"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, start, end);
    }
}

