/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeLongCoercer;
import com.espertech.esper.common.internal.settings.RuntimeSettingsTimeZoneField;
import java.time.LocalDateTime;
import java.util.TimeZone;

public class DatetimeLongCoercerLocalDateTime
implements DatetimeLongCoercer {
    @Override
    public long coerce(Object date) {
        return DatetimeLongCoercerLocalDateTime.coerceLDTToMilliWTimezone((LocalDateTime)date, TimeZone.getDefault());
    }

    public static long coerceLDTToMilliWTimezone(LocalDateTime ldt, TimeZone timeZone) {
        return ldt.atZone(timeZone.toZoneId()).toInstant().toEpochMilli();
    }

    @Override
    public CodegenExpression codegen(CodegenExpression value, EPTypeClass valueType, CodegenClassScope codegenClassScope) {
        if (valueType.getType() != LocalDateTime.class) {
            throw new IllegalStateException("Expected a LocalDateTime type");
        }
        CodegenExpressionField timeZoneField = codegenClassScope.addOrGetFieldSharable(RuntimeSettingsTimeZoneField.INSTANCE);
        return CodegenExpressionBuilder.exprDotMethodChain(value).add("atZone", CodegenExpressionBuilder.exprDotMethod(timeZoneField, "toZoneId", new CodegenExpression[0])).add("toInstant", new CodegenExpression[0]).add("toEpochMilli", new CodegenExpression[0]);
    }
}

