/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanCalOpsForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanIntervalNoEndTSForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanIntervalWithEndForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalBeanReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsCalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsDateForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsLocalDateTimeForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsLongForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalOpsZonedDateTimeForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalCalReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalDateReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalEvaluator;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalForgeIntervalComp;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLDTIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLocalDateTimeReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalLongReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZDTIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeOpsIntervalForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeOpsReformatForge;
import com.espertech.esper.common.internal.epl.datetime.dtlocal.DTLocalZonedDateTimeReformatForge;
import com.espertech.esper.common.internal.epl.datetime.interval.IntervalForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEvalVisitor;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ExprDotDTForge
implements ExprDotForge {
    private final EPChainableTypeClass returnType;
    private final DTLocalForge forge;

    ExprDotDTForge(List<CalendarForge> calendarForges, TimeAbacus timeAbacus, ReformatForge reformatForge, IntervalForge intervalForge, EPTypeClass inputType, EventType inputEventType) throws ExprValidationException {
        this.returnType = intervalForge != null ? EPChainableTypeHelper.singleValueNonNull(EPTypePremade.BOOLEANBOXED.getEPType()) : (reformatForge != null ? EPChainableTypeHelper.singleValueNonNull(reformatForge.getReturnType()) : (inputEventType != null ? EPChainableTypeHelper.singleValueNonNull(inputEventType.getPropertyEPType(inputEventType.getStartTimestampPropertyName())) : EPChainableTypeHelper.singleValueNonNull(inputType == EPTypePremade.SQLDATE.getEPType() ? EPTypePremade.DATE.getEPType() : inputType)));
        this.forge = this.getForge(calendarForges, timeAbacus, inputType, inputEventType, reformatForge, intervalForge);
    }

    @Override
    public ExprDotEval getDotEvaluator() {
        final DTLocalEvaluator evaluator = this.forge.getDTEvaluator();
        final ExprDotDTForge exprDotForge = this;
        return new ExprDotEval(){

            @Override
            public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                if (target == null) {
                    return null;
                }
                return evaluator.evaluate(target, eventsPerStream, isNewData, exprEvaluatorContext);
            }

            @Override
            public ExprDotForge getDotForge() {
                return exprDotForge;
            }
        };
    }

    @Override
    public CodegenExpression codegen(CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod methodNode = parent.makeChild(this.returnType.getType(), ExprDotDTForge.class, (CodegenScope)classScope).addParam(innerType, "target");
        CodegenBlock block = methodNode.getBlock();
        if (!innerType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("target");
        }
        block.methodReturn(this.forge.codegen(CodegenExpressionBuilder.ref("target"), innerType, methodNode, symbols, classScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public EPChainableType getTypeInfo() {
        return this.returnType;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitDateTime();
    }

    public DTLocalForge getForge(List<CalendarForge> calendarForges, TimeAbacus timeAbacus, EPTypeClass inputTypeClass, EventType inputEventType, ReformatForge reformatForge, IntervalForge intervalForge) throws ExprValidationException {
        if (inputEventType == null) {
            Class<?> inputType = inputTypeClass.getType();
            if (reformatForge != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalCalReformatForge(reformatForge);
                    }
                    return new DTLocalCalOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalDateReformatForge(reformatForge);
                    }
                    return new DTLocalDateOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLongReformatForge(reformatForge);
                    }
                    return new DTLocalLongOpsReformatForge(calendarForges, reformatForge, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLocalDateTimeReformatForge(reformatForge);
                    }
                    return new DTLocalLocalDateTimeOpsReformatForge(calendarForges, reformatForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalZonedDateTimeReformatForge(reformatForge);
                    }
                    return new DTLocalZonedDateTimeOpsReformatForge(calendarForges, reformatForge);
                }
            } else if (intervalForge != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalCalIntervalForge(intervalForge);
                    }
                    return new DTLocalCalOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalDateIntervalForge(intervalForge);
                    }
                    return new DTLocalDateOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLongIntervalForge(intervalForge);
                    }
                    return new DTLocalLongOpsIntervalForge(calendarForges, intervalForge, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalLDTIntervalForge(intervalForge);
                    }
                    return new DTLocalLocalDateTimeOpsIntervalForge(calendarForges, intervalForge);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarForges.isEmpty()) {
                        return new DTLocalZDTIntervalForge(intervalForge);
                    }
                    return new DTLocalZonedDateTimeOpsIntervalForge(calendarForges, intervalForge);
                }
            } else {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    return new DTLocalCalOpsCalForge(calendarForges);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    return new DTLocalCalOpsDateForge(calendarForges);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    return new DTLocalCalOpsLongForge(calendarForges, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    return new DTLocalCalOpsLocalDateTimeForge(calendarForges);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    return new DTLocalCalOpsZonedDateTimeForge(calendarForges);
                }
            }
            throw new ExprValidationException("Invalid input type '" + inputType + "'");
        }
        String propertyNameStart = inputEventType.getStartTimestampPropertyName();
        EventPropertyGetterSPI getter = ((EventTypeSPI)inputEventType).getGetterSPI(propertyNameStart);
        EPType getterResultEPType = inputEventType.getPropertyEPType(propertyNameStart);
        this.checkNotNull(getterResultEPType, propertyNameStart);
        EPTypeClass getterResultType = (EPTypeClass)getterResultEPType;
        if (reformatForge != null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, reformatForge, null);
            return new DTLocalBeanReformatForge(getter, getterResultType, inner, reformatForge.getReturnType());
        }
        if (intervalForge == null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, null, null);
            return new DTLocalBeanCalOpsForge(getter, getterResultType, inner, (EPTypeClass)EPChainableTypeHelper.getNormalizedEPType(this.returnType));
        }
        if (inputEventType.getEndTimestampPropertyName() == null) {
            DTLocalForge inner = this.getForge(calendarForges, timeAbacus, getterResultType, null, null, intervalForge);
            return new DTLocalBeanIntervalNoEndTSForge(getter, getterResultType, inner, (EPTypeClass)EPChainableTypeHelper.getNormalizedEPType(this.returnType));
        }
        String propertyNameEnd = inputEventType.getEndTimestampPropertyName();
        EventPropertyGetterSPI getterEndTimestamp = ((EventTypeSPI)inputEventType).getGetterSPI(propertyNameEnd);
        EPType getterEndType = inputEventType.getPropertyEPType(propertyNameEnd);
        this.checkNotNull(getterEndType, propertyNameEnd);
        DTLocalForgeIntervalComp inner = (DTLocalForgeIntervalComp)((Object)this.getForge(calendarForges, timeAbacus, getterResultType, null, null, intervalForge));
        return new DTLocalBeanIntervalWithEndForge(getter, getterResultType, getterEndTimestamp, (EPTypeClass)getterEndType, inner);
    }

    private void checkNotNull(EPType getterResultEPType, String propertyName) throws ExprValidationException {
        if (getterResultEPType == null || getterResultEPType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Invalid null-type input for property '" + propertyName + "'");
        }
    }
}

