/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.plugin;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.datetimemethod.DateTimeMethodOpsReformat;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.plugin.DTMPluginUtil;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;

public class DTMPluginReformatForge
implements ReformatForge {
    private final DateTimeMethodOpsReformat reformatOp;
    private final List<ExprNode> reformatOpParams;

    public DTMPluginReformatForge(EPTypeClass inputType, DateTimeMethodOpsReformat reformatOp, List<ExprNode> reformatOpParams) throws ExprValidationException {
        this.reformatOp = reformatOp;
        this.reformatOpParams = reformatOpParams;
        DTMPluginUtil.validateDTMStaticMethodAllowNull(inputType, reformatOp.getLongOp(), EPTypePremade.LONGPRIMITIVE.getEPType(), reformatOpParams);
        DTMPluginUtil.validateDTMStaticMethodAllowNull(inputType, reformatOp.getDateOp(), EPTypePremade.DATE.getEPType(), reformatOpParams);
        DTMPluginUtil.validateDTMStaticMethodAllowNull(inputType, reformatOp.getCalendarOp(), EPTypePremade.CALENDAR.getEPType(), reformatOpParams);
        DTMPluginUtil.validateDTMStaticMethodAllowNull(inputType, reformatOp.getLdtOp(), EPTypePremade.LOCALDATETIME.getEPType(), reformatOpParams);
        DTMPluginUtil.validateDTMStaticMethodAllowNull(inputType, reformatOp.getZdtOp(), EPTypePremade.ZONEDDATETIME.getEPType(), reformatOpParams);
        if (reformatOp.getReturnType() == null || JavaClassHelper.isTypeVoid(reformatOp.getReturnType())) {
            throw new ExprValidationException("Invalid return type for reformat operation, return type is " + reformatOp.getReturnType());
        }
    }

    @Override
    public ReformatOp getOp() {
        throw new UnsupportedOperationException("Evaluation not available at compile-time");
    }

    @Override
    public EPTypeClass getReturnType() {
        return this.reformatOp.getReturnType();
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodDesc currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return DTMPluginUtil.codegenPluginDTM(this.reformatOp.getLongOp(), this.getReturnType(), EPTypePremade.LONGPRIMITIVE.getEPType(), inner, this.reformatOpParams, parent, symbols, classScope);
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return DTMPluginUtil.codegenPluginDTM(this.reformatOp.getDateOp(), this.getReturnType(), EPTypePremade.DATE.getEPType(), inner, this.reformatOpParams, parent, symbols, classScope);
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return DTMPluginUtil.codegenPluginDTM(this.reformatOp.getCalendarOp(), this.getReturnType(), EPTypePremade.CALENDAR.getEPType(), inner, this.reformatOpParams, parent, symbols, classScope);
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return DTMPluginUtil.codegenPluginDTM(this.reformatOp.getLdtOp(), this.getReturnType(), EPTypePremade.LOCALDATETIME.getEPType(), inner, this.reformatOpParams, parent, symbols, classScope);
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        return DTMPluginUtil.codegenPluginDTM(this.reformatOp.getZdtOp(), this.getReturnType(), EPTypePremade.ZONEDDATETIME.getEPType(), inner, this.reformatOpParams, parent, symbols, classScope);
    }
}

