/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.reformatop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.common.internal.epl.datetime.eval.DatetimeMethodDesc;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatFormatForgeDesc;
import com.espertech.esper.common.internal.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzerAffector;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReformatFormatForge
implements ReformatForge,
ReformatOp {
    private final ReformatFormatForgeDesc formatterType;
    private final ExprForge formatter;
    private final TimeAbacus timeAbacus;

    public ReformatFormatForge(ReformatFormatForgeDesc formatterType, ExprForge formatter, TimeAbacus timeAbacus) {
        this.formatterType = formatterType;
        this.formatter = formatter;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    @Override
    public synchronized Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.timeAbacus.getOneSecond() == 1000L) {
            return this.getDateFormatFormatter().format(ts);
        }
        return this.getDateFormatFormatter().format(this.timeAbacus.toDate(ts));
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope classScope) {
        CodegenExpressionField formatField = this.codegenFormatFieldInit(classScope);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(EPTypePremade.STRING.getEPType(), ReformatFormatForge.class, (CodegenScope)classScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "ts").getBlock();
        CodegenBlock syncBlock = blockMethod.synchronizedOn(formatField);
        if (this.timeAbacus.getOneSecond() == 1000L) {
            syncBlock.blockReturn(CodegenExpressionBuilder.exprDotMethod(formatField, "format", CodegenExpressionBuilder.ref("ts")));
        } else {
            syncBlock.blockReturn(CodegenExpressionBuilder.exprDotMethod(formatField, "format", this.timeAbacus.toDateCodegen(CodegenExpressionBuilder.ref("ts"))));
        }
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public synchronized Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.getDateFormatFormatter().format(d);
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField formatField = this.codegenFormatFieldInit(codegenClassScope);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(EPTypePremade.STRING.getEPType(), ReformatFormatForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.DATE.getEPType(), "d").getBlock().synchronizedOn(formatField).blockReturn(CodegenExpressionBuilder.exprDotMethod(formatField, "format", CodegenExpressionBuilder.ref("d")));
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public synchronized Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.getDateFormatFormatter().format(cal.getTime());
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField formatField = this.codegenFormatFieldInit(codegenClassScope);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(EPTypePremade.STRING.getEPType(), ReformatFormatForge.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.CALENDAR.getEPType(), "cal").getBlock().synchronizedOn(formatField).blockReturn(CodegenExpressionBuilder.exprDotMethod(formatField, "format", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTime", new CodegenExpression[0])));
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return ldt.format(this.getDateFormatterJava8());
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField formatField = this.codegenFormatFieldInit(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(inner, "format", formatField);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return zdt.format(this.getDateFormatterJava8());
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpressionField formatField = this.codegenFormatFieldInit(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(inner, "format", formatField);
    }

    @Override
    public EPTypeClass getReturnType() {
        return EPTypePremade.STRING.getEPType();
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodDesc currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }

    private CodegenExpressionField codegenFormatFieldInit(CodegenClassScope classScope) {
        CodegenExpressionLocalMethod init;
        CodegenMethod formatEvalCall = CodegenLegoMethodExpression.codegenExpression(this.formatter, classScope.getPackageScope().getInitMethod(), classScope);
        CodegenExpressionLocalMethod formatEval = CodegenExpressionBuilder.localMethod(formatEvalCall, CodegenExpressionBuilder.constantNull(), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull());
        if (this.formatterType.getFormatterType() != String.class) {
            init = formatEval;
        } else {
            CodegenMethod parse = classScope.getPackageScope().getInitMethod().makeChild(this.formatterType.isJava8() ? EPTypePremade.DATETIMEFORMATTER.getEPType() : EPTypePremade.DATEFORMAT.getEPType(), this.getClass(), (CodegenScope)classScope);
            if (this.formatterType.isJava8()) {
                parse.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(DateTimeFormatter.class, "ofPattern", formatEval));
            } else {
                parse.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(EPTypePremade.SIMPLEDATEFORMAT.getEPType(), formatEval));
            }
            init = CodegenExpressionBuilder.localMethod(parse, new CodegenExpression[0]);
        }
        return classScope.addFieldUnshared(true, this.formatterType.isJava8() ? EPTypePremade.DATETIMEFORMATTER.getEPType() : EPTypePremade.DATEFORMAT.getEPType(), init);
    }

    private DateFormat getDateFormatFormatter() {
        return (DateFormat)this.formatter.getExprEvaluator().evaluate(null, true, null);
    }

    private DateTimeFormatter getDateFormatterJava8() {
        return (DateTimeFormatter)this.formatter.getExprEvaluator().evaluate(null, true, null);
    }
}

