/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collection;

public class ExprDotStaticMethodWrapArrayScalar
implements ExprDotStaticMethodWrap {
    private final String methodName;
    private final EPTypeClass arrayType;

    public ExprDotStaticMethodWrapArrayScalar(String methodName, EPTypeClass arrayType) {
        this.methodName = methodName;
        this.arrayType = arrayType;
    }

    @Override
    public EPChainableType getTypeInfo() {
        EPTypeClass component = JavaClassHelper.getArrayComponentType(this.arrayType);
        return EPChainableTypeHelper.collectionOfSingleValue(component);
    }

    @Override
    public Collection convertNonNull(Object result) {
        return CollectionUtil.arrayToCollectionAllowNull(result);
    }

    @Override
    public CodegenExpression codegenConvertNonNull(CodegenExpression result, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CollectionUtil.arrayToCollectionAllowNullCodegen(codegenMethodScope, this.arrayType, result, codegenClassScope);
    }
}

