/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.dot;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import java.io.StringWriter;

public class PropertyDotNonLambdaFragmentIndexedForge
implements ExprForge,
ExprEvaluator,
ExprNodeRenderable {
    private final int streamId;
    private final EventPropertyGetterSPI getter;
    private final ExprNode indexExpr;
    private final String propertyName;

    public PropertyDotNonLambdaFragmentIndexedForge(int streamId, EventPropertyGetterSPI getter, ExprNode indexExpr, String propertyName) {
        this.streamId = streamId;
        this.getter = getter;
        this.indexExpr = indexExpr;
        this.propertyName = propertyName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return EventBean.EPTYPE;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return null;
        }
        Object result = this.getter.getFragment(event);
        if (result == null || !result.getClass().isArray()) {
            return null;
        }
        EventBean[] events = (EventBean[])result;
        Integer index = (Integer)this.indexExpr.getForge().getExprEvaluator().evaluate(eventsPerStream, isNewData, context);
        if (index == null) {
            return null;
        }
        return events[index];
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(EventBean.EPTYPE, PropertyDotNonLambdaFragmentIndexedForge.class, (CodegenScope)classScope);
        CodegenExpressionRef refEPS = symbols.getAddEPS(method);
        method.getBlock().declareVar(EventBean.EPTYPE, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamId))).ifRefNullReturnNull("event").declareVar(EventBean.EPTYPEARRAY, "array", CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, this.getter.eventBeanFragmentCodegen(CodegenExpressionBuilder.ref("event"), method, classScope))).declareVar(EPTypePremade.INTEGERBOXED.getEPType(), "index", this.indexExpr.getForge().evaluateCodegen(EPTypePremade.INTEGERBOXED.getEPType(), method, symbols, classScope)).ifRefNullReturnNull("index").ifCondition(CodegenExpressionBuilder.relational(CodegenExpressionBuilder.ref("index"), CodegenExpressionRelational.CodegenRelational.GE, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")))).blockThrow(CodegenExpressionBuilder.newInstance(EPException.EPTYPE, CodegenExpressionBuilder.concat(CodegenExpressionBuilder.constant("Array length "), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionBuilder.constant(" less than index "), CodegenExpressionBuilder.ref("index"), CodegenExpressionBuilder.constant(" for property '" + this.propertyName + "'")))).methodReturn(CodegenLegoCast.castSafeFromObjectType(EventBean.EPTYPE, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.cast(EPTypePremade.INTEGERPRIMITIVE.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("index")))));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence, ExprNodeRenderableFlags flags) {
        writer.append(this.getClass().getSimpleName());
    }
}

