/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.arrayOf;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotEvalParamLambda;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.base.ThreeFormScalar;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;

public class EnumArrayOfScalar
extends ThreeFormScalar {
    private final EPTypeClass arrayComponentType;

    public EnumArrayOfScalar(ExprDotEvalParamLambda lambda, ObjectArrayEventType fieldEventType, int numParameters, EPTypeClass arrayComponentType) {
        super(lambda, fieldEventType, numParameters);
        this.arrayComponentType = arrayComponentType;
    }

    @Override
    public EnumEval getEnumEvaluator() {
        ExprEvaluator inner = this.innerExpression.getExprEvaluator();
        return (eventsLambda, enumcoll, isNewData, context) -> {
            Object array = Array.newInstance(this.arrayComponentType.getType(), enumcoll.size());
            if (enumcoll.isEmpty()) {
                return array;
            }
            ObjectArrayEventBean evalEvent = new ObjectArrayEventBean(new Object[3], this.fieldEventType);
            eventsLambda[this.getStreamNumLambda()] = evalEvent;
            Object[] evalProps = evalEvent.getProperties();
            evalProps[2] = enumcoll.size();
            int count = -1;
            for (Object next : enumcoll) {
                evalProps[0] = next;
                evalProps[1] = ++count;
                Object item = inner.evaluate(eventsLambda, isNewData, context);
                Array.set(array, count, item);
            }
            return array;
        };
    }

    @Override
    public EPTypeClass returnTypeOfMethod() {
        return JavaClassHelper.getArrayType(this.arrayComponentType);
    }

    @Override
    public CodegenExpression returnIfEmptyOptional() {
        return CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.constant(0));
    }

    @Override
    public void initBlock(CodegenBlock block, CodegenMethod methodNode, ExprForgeCodegenSymbol scope, CodegenClassScope codegenClassScope) {
        EPTypeClass arrayType = this.returnTypeOfMethod();
        block.declareVar(arrayType, "result", CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.exprDotMethod(EnumForgeCodegenNames.REF_ENUMCOLL, "size", new CodegenExpression[0]))).declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "index", CodegenExpressionBuilder.constant(0));
    }

    @Override
    public void forEachBlock(CodegenBlock block, CodegenMethod methodNode, ExprForgeCodegenSymbol scope, CodegenClassScope codegenClassScope) {
        block.declareVar(EPTypePremade.OBJECT.getEPType(), "item", this.innerExpression.evaluateCodegen(EPTypePremade.OBJECT.getEPType(), methodNode, scope, codegenClassScope)).assignArrayElement(CodegenExpressionBuilder.ref("result"), (CodegenExpression)CodegenExpressionBuilder.ref("index"), CodegenExpressionBuilder.cast(this.arrayComponentType, (CodegenExpression)CodegenExpressionBuilder.ref("item"))).incrementRef("index");
    }

    @Override
    public void returnResult(CodegenBlock block) {
        block.methodReturn(CodegenExpressionBuilder.ref("result"));
    }
}

