/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.enummethod.eval.singlelambdaopt3form.arrayOf;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenNames;
import com.espertech.esper.common.internal.epl.enummethod.codegen.EnumForgeCodegenParams;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumEval;
import com.espertech.esper.common.internal.epl.enummethod.eval.EnumForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;

public class EnumArrayOfScalarNoParams
implements EnumForge {
    private final EPTypeClass arrayComponentType;

    public EnumArrayOfScalarNoParams(EPTypeClass arrayComponentType) {
        this.arrayComponentType = arrayComponentType;
    }

    public EPTypeClass getArrayComponentType() {
        return this.arrayComponentType;
    }

    @Override
    public EnumEval getEnumEvaluator() {
        return new EnumEval(){

            @Override
            public Object evaluateEnumMethod(EventBean[] eventsLambda, Collection enumcoll, boolean isNewData, ExprEvaluatorContext context) {
                Object array = Array.newInstance(EnumArrayOfScalarNoParams.this.arrayComponentType.getType(), enumcoll.size());
                if (enumcoll.isEmpty()) {
                    return array;
                }
                int count = 0;
                for (Object next : enumcoll) {
                    Array.set(array, count, next);
                    ++count;
                }
                return array;
            }
        };
    }

    @Override
    public CodegenExpression codegen(EnumForgeCodegenParams premade, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        EPTypeClass arrayType = JavaClassHelper.getArrayType(this.arrayComponentType);
        ExprForgeCodegenSymbol scope = new ExprForgeCodegenSymbol(false, null);
        CodegenMethod methodNode = codegenMethodScope.makeChildWithScope(arrayType, EnumArrayOfScalarNoParams.class, scope, codegenClassScope).addParam(EnumForgeCodegenNames.PARAMSCOLLOBJ);
        CodegenBlock block = methodNode.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(EnumForgeCodegenNames.REF_ENUMCOLL, "isEmpty", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.constant(0))).declareVar(arrayType, "result", CodegenExpressionBuilder.newArrayByLength(this.arrayComponentType, CodegenExpressionBuilder.exprDotMethod(EnumForgeCodegenNames.REF_ENUMCOLL, "size", new CodegenExpression[0]))).declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "count", CodegenExpressionBuilder.constant(0));
        block.forEach(EPTypePremade.OBJECT.getEPType(), "next", EnumForgeCodegenNames.REF_ENUMCOLL).assignArrayElement(CodegenExpressionBuilder.ref("result"), (CodegenExpression)CodegenExpressionBuilder.ref("count"), CodegenExpressionBuilder.cast(this.arrayComponentType, (CodegenExpression)CodegenExpressionBuilder.ref("next"))).incrementRef("count");
        block.methodReturn(CodegenExpressionBuilder.ref("result"));
        return CodegenExpressionBuilder.localMethod(methodNode, premade.getEps(), premade.getEnumcoll(), premade.getIsNewData(), premade.getExprCtx());
    }

    @Override
    public int getStreamNumSize() {
        return 0;
    }
}

