/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.agg.accessagg;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentDefault;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentForge;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationAgentForgeFactory;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationStateKeyWStream;
import com.espertech.esper.common.internal.epl.agg.access.core.AggregationStateTypeWStream;
import com.espertech.esper.common.internal.epl.agg.access.sorted.AggregationAccessorMinMaxByNonTable;
import com.espertech.esper.common.internal.epl.agg.access.sorted.AggregationAccessorMinMaxByTable;
import com.espertech.esper.common.internal.epl.agg.access.sorted.AggregationAccessorSortedNonTable;
import com.espertech.esper.common.internal.epl.agg.access.sorted.AggregationAccessorSortedTable;
import com.espertech.esper.common.internal.epl.agg.access.sorted.AggregationForgeFactoryAccessSorted;
import com.espertech.esper.common.internal.epl.agg.access.sorted.SortedAggregationStateDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionNode;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.List;
import java.util.Set;

public class ExprAggMultiFunctionSortedMinMaxByNode
extends ExprAggregateNodeBase
implements ExprEnumerationForge,
ExprAggMultiFunctionNode {
    private final boolean max;
    private final boolean ever;
    private final boolean sortedwin;
    private EventType containedType;
    private AggregationForgeFactory aggregationForgeFactory;

    public ExprAggMultiFunctionSortedMinMaxByNode(boolean max, boolean ever, boolean sortedwin) {
        super(false);
        this.max = max;
        this.ever = ever;
        this.sortedwin = sortedwin;
    }

    @Override
    public AggregationForgeFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationForgeFactoryAccessSorted factory = validationContext.getStatementRawInfo().getStatementType() == StatementType.CREATE_TABLE ? this.handleCreateTable(validationContext) : (validationContext.getStatementRawInfo().getIntoTableName() != null ? this.handleIntoTable(validationContext) : this.handleNonTable(validationContext));
        this.containedType = factory.getContainedEventType();
        this.aggregationForgeFactory = factory;
        return factory;
    }

    private AggregationForgeFactoryAccessSorted handleNonTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        EPTypeClass componentType;
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("Missing the sort criteria expression");
        }
        Set<Integer> streams = ExprNodeUtilityQuery.getIdentStreamNumbers(this.positionalParams[0]);
        if (streams.size() > 1 || streams.isEmpty()) {
            throw new ExprValidationException(this.getErrorPrefix() + " requires that any parameter expressions evaluate properties of the same stream");
        }
        int streamNum = streams.iterator().next();
        if (!this.ever && ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(validationContext.getStreamTypeService(), streamNum) && this.sortedwin) {
            throw new ExprValidationException(this.getErrorPrefix() + " requires that a data window is declared for the stream");
        }
        this.containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        EPTypeClass accessorResultType = componentType = this.containedType.getUnderlyingEPType();
        TableMetaData tableMetadata = validationContext.getTableCompileTimeResolver().resolveTableFromEventType(this.containedType);
        if (!this.sortedwin) {
            accessor = tableMetadata != null ? new AggregationAccessorMinMaxByTable(this.max, tableMetadata) : new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = tableMetadata != null ? new AggregationAccessorSortedTable(this.max, componentType, tableMetadata) : new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        Pair<ExprNode[], boolean[]> criteriaExpressions = this.getCriteriaExpressions();
        AggregationStateTypeWStream type = this.ever ? (this.max ? AggregationStateTypeWStream.MAXEVER : AggregationStateTypeWStream.MINEVER) : AggregationStateTypeWStream.SORTED;
        AggregationStateKeyWStream stateKey = new AggregationStateKeyWStream(streamNum, this.containedType, type, criteriaExpressions.getFirst(), this.optionalFilter);
        ExprForge optionalFilterForge = this.optionalFilter == null ? null : this.optionalFilter.getForge();
        EventType streamEventType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        EPType[] criteriaTypes = ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions.getFirst());
        DataInputOutputSerdeForge[] criteriaSerdes = new DataInputOutputSerdeForge[criteriaTypes.length];
        for (int i = 0; i < criteriaTypes.length; ++i) {
            criteriaSerdes[i] = validationContext.getSerdeResolver().serdeForAggregation(criteriaTypes[i], validationContext.getStatementRawInfo());
        }
        SortedAggregationStateDesc sortedDesc = new SortedAggregationStateDesc(this.max, validationContext.getClasspathImportService(), criteriaExpressions.getFirst(), criteriaTypes, criteriaSerdes, criteriaExpressions.getSecond(), this.ever, streamNum, this, optionalFilterForge, streamEventType);
        List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(this.containedType, validationContext.getStatementRawInfo(), validationContext.getSerdeEventTypeRegistry(), validationContext.getSerdeResolver(), validationContext.getStateMgmtSettingsProvider());
        validationContext.getAdditionalForgeables().addAll(serdeForgeables);
        return new AggregationForgeFactoryAccessSorted(this, accessor, accessorResultType, this.containedType, stateKey, sortedDesc, AggregationAgentDefault.INSTANCE);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionEventsCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(future, "getCollectionOfEvents", CodegenExpressionBuilder.constant(this.column), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
    }

    private AggregationForgeFactoryAccessSorted handleIntoTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        EPTypeClass componentType;
        int streamNum;
        if (this.positionalParams.length == 0 || this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprWildcard) {
            ExprAggMultiFunctionUtil.validateWildcardStreamNumbers(validationContext.getStreamTypeService(), this.getAggregationFunctionName());
            streamNum = 0;
        } else if (this.positionalParams.length == 1 && this.positionalParams[0] instanceof ExprStreamUnderlyingNode) {
            streamNum = ExprAggMultiFunctionUtil.validateStreamWildcardGetStreamNum(this.positionalParams[0]);
        } else {
            if (this.positionalParams.length > 0) {
                throw new ExprValidationException("When specifying into-table a sort expression cannot be provided");
            }
            streamNum = 0;
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        EPTypeClass accessorResultType = componentType = containedType.getUnderlyingEPType();
        if (!this.sortedwin) {
            accessor = new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        AggregationAgentForge agent = AggregationAgentForgeFactory.make(streamNum, this.optionalFilter, validationContext.getClasspathImportService(), validationContext.getStreamTypeService().isOnDemandStreams(), validationContext.getStatementName());
        return new AggregationForgeFactoryAccessSorted(this, accessor, accessorResultType, containedType, null, null, agent);
    }

    private AggregationForgeFactoryAccessSorted handleCreateTable(ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessorForge accessor;
        if (this.positionalParams.length == 0) {
            throw new ExprValidationException("Missing the sort criteria expression");
        }
        String message = "For tables columns, the aggregation function requires the 'sorted(*)' declaration";
        if (!this.sortedwin && !this.ever) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException("'Sorted' requires that the event type is provided");
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[0];
        EPTypeClass componentType = containedType.getUnderlyingEPType();
        Pair<ExprNode[], boolean[]> criteriaExpressions = this.getCriteriaExpressions();
        EPTypeClass accessorResultType = componentType;
        if (!this.sortedwin) {
            accessor = new AggregationAccessorMinMaxByNonTable(this.max);
        } else {
            accessor = new AggregationAccessorSortedNonTable(this.max, componentType);
            accessorResultType = JavaClassHelper.getArrayType(accessorResultType);
        }
        EPType[] criteriaTypes = ExprNodeUtilityQuery.getExprResultTypes(criteriaExpressions.getFirst());
        DataInputOutputSerdeForge[] criteriaSerdes = new DataInputOutputSerdeForge[criteriaTypes.length];
        for (int i = 0; i < criteriaTypes.length; ++i) {
            criteriaSerdes[i] = validationContext.getSerdeResolver().serdeForAggregation(criteriaTypes[i], validationContext.getStatementRawInfo());
        }
        SortedAggregationStateDesc stateDesc = new SortedAggregationStateDesc(this.max, validationContext.getClasspathImportService(), criteriaExpressions.getFirst(), criteriaTypes, criteriaSerdes, criteriaExpressions.getSecond(), this.ever, 0, this, null, containedType);
        List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(containedType, validationContext.getStatementRawInfo(), validationContext.getSerdeEventTypeRegistry(), validationContext.getSerdeResolver(), validationContext.getStateMgmtSettingsProvider());
        validationContext.getAdditionalForgeables().addAll(serdeForgeables);
        return new AggregationForgeFactoryAccessSorted(this, accessor, accessorResultType, containedType, null, stateDesc, null);
    }

    private Pair<ExprNode[], boolean[]> getCriteriaExpressions() {
        ExprNode[] criteriaExpressions = new ExprNode[this.positionalParams.length];
        boolean[] sortDescending = new boolean[this.positionalParams.length];
        for (int i = 0; i < this.positionalParams.length; ++i) {
            ExprNode parameter;
            criteriaExpressions[i] = parameter = this.positionalParams[i];
            if (!(parameter instanceof ExprOrderedExpr)) continue;
            ExprOrderedExpr ordered = (ExprOrderedExpr)parameter;
            sortDescending[i] = ordered.isDescending();
            if (ordered.isDescending()) continue;
            criteriaExpressions[i] = ordered.getChildNodes()[0];
        }
        return new Pair<ExprNode[], boolean[]>(criteriaExpressions, sortDescending);
    }

    @Override
    public String getAggregationFunctionName() {
        if (this.sortedwin) {
            return "sorted";
        }
        if (this.ever) {
            return this.max ? "maxbyever" : "minbyever";
        }
        return this.max ? "maxby" : "minby";
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append(this.getAggregationFunctionName());
        ExprNodeUtilityPrint.toExpressionStringParams(writer, this.positionalParams);
    }

    @Override
    public CodegenExpression evaluateGetROCollectionScalarCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantNull();
    }

    @Override
    public EventType getEventTypeCollection(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) {
        if (!this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public EPTypeClass getComponentTypeCollection() throws ExprValidationException {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(StatementRawInfo statementRawInfo, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        if (this.sortedwin) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public CodegenExpression evaluateGetEventBeanCodegen(CodegenMethodScope parent, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenExpression future = this.getAggFuture(codegenClassScope);
        return CodegenExpressionBuilder.exprDotMethod(future, "getEventBean", CodegenExpressionBuilder.constant(this.column), exprSymbol.getAddEPS(parent), exprSymbol.getAddIsNewData(parent), exprSymbol.getAddExprEvalCtx(parent));
    }

    public boolean isMax() {
        return this.max;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }

    @Override
    protected boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprAggMultiFunctionSortedMinMaxByNode)) {
            return false;
        }
        ExprAggMultiFunctionSortedMinMaxByNode other = (ExprAggMultiFunctionSortedMinMaxByNode)node;
        return this.max == other.max && this.containedType == other.containedType && this.sortedwin == other.sortedwin && this.ever == other.ever;
    }

    @Override
    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public AggregationForgeFactory getAggregationForgeFactory() {
        return this.aggregationForgeFactory;
    }

    private String getErrorPrefix() {
        return "The '" + this.getAggregationFunctionName() + "' aggregation function";
    }
}

