/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.assign;

import com.espertech.esper.common.internal.epl.expression.assign.ExprAssignmentLHS;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableArray;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import java.util.Collections;
import java.util.List;

public class ExprAssignmentLHSArrayElement
extends ExprAssignmentLHS {
    private List<ExprNode> indexExpressions;

    public ExprAssignmentLHSArrayElement(String ident, List<ExprNode> indexExpressions) {
        super(ident);
        this.indexExpressions = indexExpressions;
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        for (ExprNode node : this.indexExpressions) {
            node.accept(visitor);
        }
    }

    @Override
    public void validate(ExprNodeOrigin origin, ExprValidationContext validationContext) throws ExprValidationException {
        ExprNode index = this.indexExpressions.get(0);
        index = ExprNodeUtilityValidate.getValidatedSubtree(origin, index, validationContext);
        this.indexExpressions = Collections.singletonList(index);
        ChainableArray.validateSingleIndexExpr(this.indexExpressions, () -> "expression '" + this.ident + "'");
        EPStatementStartMethodHelperValidate.validateNoAggregations(index, "Aggregation functions may not be used within update-set");
    }

    public ExprNode getIndexExpression() {
        return this.indexExpressions.get(0);
    }

    @Override
    public String getFullIdentifier() {
        return this.ident;
    }
}

