/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;

public class CodegenLegoBooleanExpression {
    private static final String PASS_NAME = "pass";

    public static void codegenReturnBoolIfNullOrBool(CodegenBlock block, EPType evaluationType, CodegenExpression expression, boolean earlyExitIfNull, Boolean resultEarlyExit, boolean checkFor, boolean resultIfCheckPasses) {
        EPTypeClass evaluationClass = CodegenLegoBooleanExpression.checkBooleanEvalType(evaluationType);
        block.declareVar(evaluationClass, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.notOptional(!checkFor, CodegenExpressionBuilder.ref(PASS_NAME));
        if (evaluationClass.getType().isPrimitive()) {
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        if (earlyExitIfNull) {
            if (resultEarlyExit == null) {
                throw new IllegalStateException("Invalid null for result-early-exit");
            }
            block.ifRefNull(PASS_NAME).blockReturn(CodegenExpressionBuilder.constant(resultEarlyExit));
            block.ifCondition(passCheck).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
            return;
        }
        block.ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(resultIfCheckPasses));
    }

    public static void codegenReturnValueIfNotNullAndNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression, CodegenExpression value) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, false, false, value);
    }

    public static void codegenReturnValueIfNullOrNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression, CodegenExpression value) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, false, false, value);
    }

    public static void codegenBreakIfNotNullAndNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, false, true, CodegenExpressionBuilder.constantNull());
    }

    public static void codegenContinueIfNotNullAndNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNotNullAndNotPass(block, evaluationType, expression, true, false, CodegenExpressionBuilder.constantNull());
    }

    public static void codegenContinueIfNullOrNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression) {
        CodegenLegoBooleanExpression.codegenDoIfNullOrNotPass(block, evaluationType, expression, true, false, CodegenExpressionBuilder.constantNull());
    }

    private static void codegenDoIfNotNullAndNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression, boolean doContinue, boolean doBreakLoop, CodegenExpression returnValue) {
        EPTypeClass evaluationClass = CodegenLegoBooleanExpression.checkBooleanEvalType(evaluationType);
        block.declareVar(evaluationClass, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(PASS_NAME));
        CodegenExpression condition = evaluationClass.getType().isPrimitive() ? passCheck : CodegenExpressionBuilder.and(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0]);
        if (doContinue) {
            block.ifCondition(condition).blockContinue();
        } else if (doBreakLoop) {
            block.ifCondition(condition).breakLoop();
        } else {
            block.ifCondition(condition).blockReturn(returnValue);
        }
    }

    private static EPTypeClass checkBooleanEvalType(EPType evaluationType) {
        if (evaluationType == null || evaluationType == EPTypeNull.INSTANCE) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        EPTypeClass type = (EPTypeClass)evaluationType;
        if (type.getType() != Boolean.TYPE && type.getType() != Boolean.class) {
            throw new IllegalStateException("Invalid non-boolean expression");
        }
        return type;
    }

    private static void codegenDoIfNullOrNotPass(CodegenBlock block, EPType evaluationType, CodegenExpression expression, boolean doContinue, boolean doBreakLoop, CodegenExpression returnValue) {
        EPTypeClass evaluationClass = CodegenLegoBooleanExpression.checkBooleanEvalType(evaluationType);
        block.declareVar(evaluationClass, PASS_NAME, expression);
        CodegenExpression passCheck = CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(PASS_NAME));
        CodegenExpression condition = evaluationClass.getType().isPrimitive() ? passCheck : CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(PASS_NAME)), passCheck, new CodegenExpression[0]);
        if (doContinue) {
            block.ifCondition(condition).blockContinue();
        } else if (doBreakLoop) {
            block.ifCondition(condition).breakLoop();
        } else {
            block.ifCondition(condition).blockReturn(returnValue);
        }
    }
}

