/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.codegen;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.EventTypeWithOptionalFlag;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExprForgeCodegenSymbol
implements CodegenSymbolProvider {
    private final boolean allowUnderlyingReferences;
    private final Boolean newDataValue;
    private int currentParamNum;
    private Map<Integer, EventTypeWithOptionalFlag> underlyingStreamNums = Collections.emptyMap();
    private CodegenExpressionRef optionalEPSRef;
    private CodegenExpressionRef optionalIsNewDataRef;
    private CodegenExpressionRef optionalExprEvalCtxRef;

    public ExprForgeCodegenSymbol(boolean allowUnderlyingReferences, Boolean newDataValue) {
        this.allowUnderlyingReferences = allowUnderlyingReferences;
        this.newDataValue = newDataValue;
    }

    public boolean isAllowUnderlyingReferences() {
        return this.allowUnderlyingReferences;
    }

    public CodegenExpressionRef getAddEPS(CodegenMethodScope scope) {
        if (this.optionalEPSRef == null) {
            this.optionalEPSRef = ExprForgeCodegenNames.REF_EPS;
        }
        scope.addSymbol(this.optionalEPSRef);
        return this.optionalEPSRef;
    }

    public CodegenExpression getAddIsNewData(CodegenMethodScope scope) {
        if (this.newDataValue != null) {
            return CodegenExpressionBuilder.constant(this.newDataValue);
        }
        if (this.optionalIsNewDataRef == null) {
            this.optionalIsNewDataRef = ExprForgeCodegenNames.REF_ISNEWDATA;
        }
        scope.addSymbol(this.optionalIsNewDataRef);
        return this.optionalIsNewDataRef;
    }

    public CodegenExpressionRef getAddExprEvalCtx(CodegenMethodScope scope) {
        if (this.optionalExprEvalCtxRef == null) {
            this.optionalExprEvalCtxRef = ExprForgeCodegenNames.REF_EXPREVALCONTEXT;
        }
        scope.addSymbol(this.optionalExprEvalCtxRef);
        return this.optionalExprEvalCtxRef;
    }

    public CodegenExpressionRef getAddRequiredUnderlying(CodegenMethodScope scope, int streamNum, EventType eventType, boolean optionalEvent) {
        EventTypeWithOptionalFlag existing;
        if (this.underlyingStreamNums.isEmpty()) {
            this.underlyingStreamNums = new HashMap<Integer, EventTypeWithOptionalFlag>();
        }
        if ((existing = this.underlyingStreamNums.get(streamNum)) != null) {
            scope.addSymbol(existing.getRef());
            return existing.getRef();
        }
        CodegenExpressionRef assigned = CodegenExpressionBuilder.ref("u" + this.currentParamNum);
        this.underlyingStreamNums.put(streamNum, new EventTypeWithOptionalFlag(assigned, eventType, optionalEvent));
        ++this.currentParamNum;
        scope.addSymbol(assigned);
        return assigned;
    }

    @Override
    public void provide(Map<String, EPTypeClass> symbols) {
        if (this.optionalEPSRef != null) {
            symbols.put(this.optionalEPSRef.getRef(), EventBean.EPTYPEARRAY);
        }
        if (this.optionalExprEvalCtxRef != null) {
            symbols.put(this.optionalExprEvalCtxRef.getRef(), ExprEvaluatorContext.EPTYPE);
        }
        if (this.optionalIsNewDataRef != null) {
            symbols.put(this.optionalIsNewDataRef.getRef(), EPTypePremade.BOOLEANPRIMITIVE.getEPType());
        }
        if (this.allowUnderlyingReferences) {
            for (Map.Entry<Integer, EventTypeWithOptionalFlag> entry : this.underlyingStreamNums.entrySet()) {
                symbols.put(entry.getValue().getRef().getRef(), entry.getValue().getEventType().getUnderlyingEPType());
            }
        }
    }

    public void derivedSymbolsCodegen(CodegenMethod parent, CodegenBlock processBlock, CodegenClassScope codegenClassScope) {
        for (Map.Entry<Integer, EventTypeWithOptionalFlag> underlying : this.underlyingStreamNums.entrySet()) {
            EPTypeClass underlyingType = underlying.getValue().getEventType().getUnderlyingEPType();
            String name = underlying.getValue().getRef().getRef();
            CodegenExpression arrayAtIndex = CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("eventsPerStream"), CodegenExpressionBuilder.constant(underlying.getKey()));
            if (!underlying.getValue().isOptionalEvent()) {
                processBlock.declareVar(underlyingType, name, CodegenExpressionBuilder.cast(underlyingType, CodegenExpressionBuilder.exprDotUnderlying(arrayAtIndex)));
                continue;
            }
            CodegenMethod methodNode = parent.makeChild(underlyingType, ExprForgeCodegenSymbol.class, (CodegenScope)codegenClassScope).addParam(EventBean.EPTYPEARRAY, "eventsPerStream");
            methodNode.getBlock().declareVar(EventBean.EPTYPE, "event", arrayAtIndex).ifRefNullReturnNull("event").methodReturn(CodegenExpressionBuilder.cast(underlyingType, CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("event"))));
            processBlock.declareVar(underlyingType, name, (CodegenExpression)CodegenExpressionBuilder.localMethod(methodNode, ExprForgeCodegenNames.REF_EPS));
        }
    }
}

