/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNodeFragmentEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForgeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;

public class ExprContextPropertyNodeImpl
extends ExprNodeBase
implements ExprContextPropertyNode,
ExprEvaluator,
ExprForgeInstrumentable {
    private final String propertyName;
    private EPType returnType;
    private transient EventPropertyGetterSPI getter;

    public ExprContextPropertyNodeImpl(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public EPType getEvaluationType() {
        return this.returnType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (validationContext.getContextDescriptor() == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        EventTypeSPI eventType = (EventTypeSPI)validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
        if (eventType == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' cannot be used in the expression as provided");
        }
        this.getter = eventType.getGetterSPI(this.propertyName);
        EPType propertyType = eventType.getPropertyEPType(this.propertyName);
        if (this.getter == null || propertyType == null) {
            throw new ExprValidationException("Context property '" + this.propertyName + "' is not a known property, known properties are " + Arrays.toString(eventType.getPropertyNames()));
        }
        this.returnType = JavaClassHelper.getBoxedType(propertyType);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean props = context.getContextProperties();
        Object result = props != null ? this.getter.get(props) : null;
        return result;
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        if (this.returnType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass returnClass = (EPTypeClass)this.returnType;
        CodegenMethod methodNode = codegenMethodScope.makeChild(returnClass, ExprContextPropertyNodeImpl.class, (CodegenScope)codegenClassScope);
        CodegenExpressionRef refExprEvalCtx = exprSymbol.getAddExprEvalCtx(methodNode);
        CodegenBlock block = methodNode.getBlock().declareVar(EventBean.EPTYPE, "props", CodegenExpressionBuilder.exprDotMethod(refExprEvalCtx, "getContextProperties", new CodegenExpression[0])).ifRefNullReturnNull("props");
        block.methodReturn(CodegenLegoCast.castSafeFromObjectType(returnClass, this.getter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("props"), methodNode, codegenClassScope)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprContextProp", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public EPType getValueType() {
        return this.returnType;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("context.").append(this.propertyName);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public EventPropertyGetterSPI getGetter() {
        return this.getter;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprContextPropertyNodeImpl that = (ExprContextPropertyNodeImpl)node;
        return this.propertyName.equals(that.propertyName);
    }

    @Override
    public ExprEnumerationForgeDesc getEnumerationForge(StreamTypeService streamTypeService, ContextCompileTimeDescriptor contextDescriptor) {
        EventTypeSPI eventType = (EventTypeSPI)contextDescriptor.getContextPropertyRegistry().getContextEventType();
        if (eventType == null) {
            return null;
        }
        FragmentEventType fragmentEventType = eventType.getFragmentType(this.propertyName);
        if (fragmentEventType == null || fragmentEventType.isIndexed()) {
            return null;
        }
        ExprContextPropertyNodeFragmentEnumerationForge forge = new ExprContextPropertyNodeFragmentEnumerationForge(this.propertyName, fragmentEventType.getFragmentType(), this.getter);
        return new ExprEnumerationForgeDesc(forge, true, -1);
    }
}

