/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbolWEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluatorForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class ExprFilterSpecLookupableForge {
    protected final String expression;
    protected final ExprEventEvaluatorForge optionalEventEvalForge;
    protected final ExprForge optionalExprForge;
    protected final EPTypeClass returnType;
    protected final boolean isNonPropertyGetter;
    protected final DataInputOutputSerdeForge valueSerde;

    public ExprFilterSpecLookupableForge(String expression, ExprEventEvaluatorForge optionalEventEvalForge, ExprForge optionalExprForge, EPTypeClass returnType, boolean isNonPropertyGetter, DataInputOutputSerdeForge valueSerde) {
        this.expression = optionalExprForge != null ? "." + expression : expression;
        this.optionalEventEvalForge = optionalEventEvalForge;
        this.optionalExprForge = optionalExprForge;
        this.returnType = JavaClassHelper.getBoxedType(returnType);
        this.isNonPropertyGetter = isNonPropertyGetter;
        this.valueSerde = valueSerde;
    }

    public EPTypeClass getReturnType() {
        return this.returnType;
    }

    public String getExpression() {
        return this.expression;
    }

    public CodegenMethod makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbolWEventType symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(ExprFilterSpecLookupable.EPTYPE, ExprFilterSpecLookupableForge.class, (CodegenScope)classScope);
        CodegenExpression singleEventEvalExpr = CodegenExpressionBuilder.constantNull();
        if (this.optionalEventEvalForge != null) {
            CodegenExpressionNewAnonymousClass anonymous = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEventEvaluator.EPTYPE);
            CodegenMethod eval = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), this.getClass(), classScope).addParam(CodegenNamedParam.from(EventBean.EPTYPE, "bean", ExprEvaluatorContext.EPTYPE, "ctx"));
            anonymous.addMethod("eval", eval);
            eval.getBlock().methodReturn(this.optionalEventEvalForge.eventBeanWithCtxGet(CodegenExpressionBuilder.ref("bean"), CodegenExpressionBuilder.ref("ctx"), method, classScope));
            singleEventEvalExpr = anonymous;
        }
        CodegenExpression epsEvalExpr = CodegenExpressionBuilder.constantNull();
        if (this.optionalExprForge != null) {
            epsEvalExpr = ExprNodeUtilityCodegen.codegenEvaluator(this.optionalExprForge, method, ExprFilterSpecLookupableForge.class, classScope);
        }
        CodegenExpression serdeExpr = this.valueSerde == null ? CodegenExpressionBuilder.constantNull() : this.valueSerde.codegen(method, classScope, null);
        CodegenExpression returnTypeExpr = this.returnType == null ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.constant(this.returnType);
        method.getBlock().declareVar(ExprEventEvaluator.EPTYPE, "eval", singleEventEvalExpr).declareVar(ExprEvaluator.EPTYPE, "expr", epsEvalExpr).declareVar(ExprFilterSpecLookupable.EPTYPE, "lookupable", CodegenExpressionBuilder.newInstance(ExprFilterSpecLookupable.EPTYPE, CodegenExpressionBuilder.constant(this.expression), CodegenExpressionBuilder.ref("eval"), CodegenExpressionBuilder.ref("expr"), returnTypeExpr, CodegenExpressionBuilder.constant(this.isNonPropertyGetter), serdeExpr)).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getFilterSharedLookupableRegistery", new CodegenExpression[0]).add("registerLookupable", symbols.getAddEventType(method), CodegenExpressionBuilder.ref("lookupable"))).methodReturn(CodegenExpressionBuilder.ref("lookupable"));
        return method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprFilterSpecLookupableForge that = (ExprFilterSpecLookupableForge)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public DataInputOutputSerdeForge getValueSerde() {
        return this.valueSerde;
    }
}

