/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.variant.VariantEventType;

public class ExprIdentNodeEvaluatorImpl
implements ExprIdentNodeEvaluator {
    private int streamNum;
    private final EventPropertyGetterSPI propertyGetter;
    protected final EPType returnType;
    private final ExprIdentNode identNode;
    private final EventTypeSPI eventType;
    private boolean optionalEvent;
    private boolean audit;

    public ExprIdentNodeEvaluatorImpl(int streamNum, EventPropertyGetterSPI propertyGetter, EPType returnType, ExprIdentNode identNode, EventTypeSPI eventType, boolean optionalEvent, boolean audit) {
        this.streamNum = streamNum;
        this.propertyGetter = propertyGetter;
        this.returnType = returnType;
        this.identNode = identNode;
        this.eventType = eventType;
        this.optionalEvent = optionalEvent;
        this.audit = audit;
    }

    @Override
    public void setOptionalEvent(boolean optionalEvent) {
        this.optionalEvent = optionalEvent;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.propertyGetter.get(event);
    }

    @Override
    public CodegenExpression codegen(EPTypeClass requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        if (!this.audit) {
            return this.codegenGet(requiredType, parent, symbols, classScope);
        }
        EPTypeClass targetType = this.getCodegenReturnType(requiredType);
        CodegenMethod method = parent.makeChild(targetType, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(targetType, "value", this.codegenGet(requiredType, method, symbols, classScope)).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddExprEvalCtx(method)).add("getAuditProvider", new CodegenExpression[0]).add("property", CodegenExpressionBuilder.constant(this.identNode.getResolvedPropertyName()), CodegenExpressionBuilder.ref("value"), symbols.getAddExprEvalCtx(method))).methodReturn(CodegenExpressionBuilder.ref("value"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private CodegenExpression codegenGet(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        boolean useUnderlying;
        if (this.returnType == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass castTargetType = this.getCodegenReturnType(requiredType);
        boolean bl = useUnderlying = exprSymbol.isAllowUnderlyingReferences() && !this.identNode.getResolvedPropertyName().contains("?") && !(this.eventType instanceof WrapperEventType) && !(this.eventType instanceof VariantEventType);
        if (useUnderlying && !this.optionalEvent) {
            CodegenExpressionRef underlying = exprSymbol.getAddRequiredUnderlying(codegenMethodScope, this.streamNum, this.eventType, false);
            return CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.underlyingGetCodegen(underlying, codegenMethodScope, codegenClassScope));
        }
        CodegenMethod method = codegenMethodScope.makeChild(castTargetType, this.getClass(), (CodegenScope)codegenClassScope);
        CodegenBlock block = method.getBlock();
        if (useUnderlying) {
            CodegenExpressionRef underlying = exprSymbol.getAddRequiredUnderlying(method, this.streamNum, this.eventType, true);
            block.ifNullReturnNull(underlying).methodReturn(CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.underlyingGetCodegen(underlying, method, codegenClassScope)));
        } else {
            CodegenExpressionRef refEPS = exprSymbol.getAddEPS(method);
            method.getBlock().declareVar(EventBean.EPTYPE, "event", CodegenExpressionBuilder.arrayAtIndex(refEPS, CodegenExpressionBuilder.constant(this.streamNum)));
            if (this.optionalEvent) {
                block.ifRefNullReturnNull("event");
            }
            block.methodReturn(CodegenLegoCast.castSafeFromObjectType(castTargetType, this.propertyGetter.eventBeanGetCodegen(CodegenExpressionBuilder.ref("event"), method, codegenClassScope)));
        }
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public EPType getEvaluationType() {
        return this.returnType;
    }

    @Override
    public EventPropertyGetterSPI getGetter() {
        return this.propertyGetter;
    }

    @Override
    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean theEvent = eventsPerStream[this.streamNum];
        if (theEvent == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(theEvent);
    }

    @Override
    public int getStreamNum() {
        return this.streamNum;
    }

    @Override
    public boolean isContextEvaluated() {
        return false;
    }

    @Override
    public EventTypeSPI getEventType() {
        return this.eventType;
    }

    private EPTypeClass getCodegenReturnType(EPTypeClass requiredType) {
        if (this.returnType == null || this.returnType == EPTypeNull.INSTANCE || requiredType.getType() == Object.class) {
            return EPTypePremade.OBJECT.getEPType();
        }
        return (EPTypeClass)this.returnType;
    }
}

