/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.compile.ContextCompileTimeDescriptor;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForgeDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEventEvaluatorForgeFromProp;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeInstrumentable;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluatorImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeFragmentTypeEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableIdentNode;
import com.espertech.esper.common.internal.epl.streamtype.PropertyResolutionDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.table.compiletime.TableCompileTimeUtil;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationBuilderExpr;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.StringValue;
import java.io.StringWriter;

public class ExprIdentNodeImpl
extends ExprNodeBase
implements ExprIdentNode,
ExprNode,
ExprForgeInstrumentable {
    private final String unresolvedPropertyName;
    private String streamOrPropertyName;
    private String resolvedStreamName;
    private String resolvedPropertyName;
    private transient StatementCompileTimeServices compileTimeServices;
    private transient ExprIdentNodeEvaluator evaluator;
    private transient StatementRawInfo statementRawInfo;

    public ExprIdentNodeImpl(String unresolvedPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = null;
    }

    public ExprIdentNodeImpl(String unresolvedPropertyName, String streamOrPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (streamOrPropertyName == null) {
            throw new IllegalArgumentException("Stream (or property name) name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public ExprIdentNodeImpl(EventType eventType, String propertyName, int streamNumber) {
        this.unresolvedPropertyName = propertyName;
        this.resolvedPropertyName = propertyName;
        EventPropertyGetterSPI propertyGetter = ((EventTypeSPI)eventType).getGetterSPI(propertyName);
        if (propertyGetter == null) {
            throw new IllegalArgumentException("Ident-node constructor could not locate property " + propertyName);
        }
        EPType propertyType = eventType.getPropertyEPType(propertyName);
        EPTypeClass type = propertyType == null || propertyType == EPTypeNull.INSTANCE ? null : (EPTypeClass)propertyType;
        this.evaluator = new ExprIdentNodeEvaluatorImpl(streamNumber, propertyGetter, JavaClassHelper.getBoxedType(type), this, (EventTypeSPI)eventType, true, false);
    }

    @Override
    public ExprForge getForge() {
        if (this.resolvedPropertyName == null) {
            throw ExprIdentNodeImpl.checkValidatedException();
        }
        return this;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public EPType getEvaluationType() {
        return this.evaluator.getEvaluationType();
    }

    @Override
    public CodegenExpression evaluateCodegenUninstrumented(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.evaluator.codegen(requiredType, codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return new InstrumentationBuilderExpr(this.getClass(), this, "ExprIdent", requiredType, codegenMethodScope, exprSymbol, codegenClassScope).build();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this.evaluator;
    }

    @Override
    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    @Override
    public String getStreamOrPropertyName() {
        return this.streamOrPropertyName;
    }

    @Override
    public void setStreamOrPropertyName(String streamOrPropertyName) {
        this.streamOrPropertyName = streamOrPropertyName;
    }

    @Override
    public void setOptionalEvent(boolean optionalEvent) {
        this.evaluator.setOptionalEvent(optionalEvent);
    }

    @Override
    public String getFullUnresolvedName() {
        if (this.streamOrPropertyName == null) {
            return this.unresolvedPropertyName;
        }
        return this.streamOrPropertyName + "." + this.unresolvedPropertyName;
    }

    @Override
    public boolean getFilterLookupEligible() {
        return this.evaluator.getStreamNum() == 0 && !this.evaluator.isContextEvaluated() && this.evaluator.getEvaluationType() != null && this.evaluator.getEvaluationType() != EPTypeNull.INSTANCE;
    }

    @Override
    public ExprFilterSpecLookupableForge getFilterLookupable() {
        EPTypeClass type = (EPTypeClass)this.evaluator.getEvaluationType();
        DataInputOutputSerdeForge serde = this.compileTimeServices.getSerdeResolver().serdeForFilter(type, this.statementRawInfo);
        ExprEventEvaluatorForgeFromProp eval = new ExprEventEvaluatorForgeFromProp(this.evaluator.getGetter());
        return new ExprFilterSpecLookupableForge(this.resolvedPropertyName, eval, null, type, false, serde);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EventPropertyGetterSPI propertyGetter;
        ExprTableIdentNode tableIdentNode;
        this.compileTimeServices = validationContext.getStatementCompileTimeService();
        this.statementRawInfo = validationContext.getStatementRawInfo();
        if (validationContext.getStreamTypeService().hasTableTypes() && (tableIdentNode = TableCompileTimeUtil.getTableIdentNode(validationContext.getStreamTypeService(), this.unresolvedPropertyName, this.streamOrPropertyName, validationContext.getTableCompileTimeResolver())) != null) {
            return tableIdentNode;
        }
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = ExprIdentNodeUtil.getTypeFromStream(validationContext.getStreamTypeService(), this.unresolvedPropertyName, this.streamOrPropertyName, false, validationContext.getTableCompileTimeResolver());
        this.resolvedStreamName = propertyInfoPair.getSecond();
        int streamNum = propertyInfoPair.getFirst().getStreamNum();
        this.resolvedPropertyName = propertyInfoPair.getFirst().getPropertyName();
        EventType eventType = propertyInfoPair.getFirst().getStreamEventType();
        try {
            propertyGetter = ((EventTypeSPI)eventType).getGetterSPI(this.resolvedPropertyName);
        }
        catch (PropertyAccessException ex) {
            throw new ExprValidationException("Property '" + this.unresolvedPropertyName + "' is not valid: " + ex.getMessage(), ex);
        }
        if (propertyGetter == null) {
            throw new ExprValidationException("Property getter not available for property '" + this.unresolvedPropertyName + "'");
        }
        boolean audit = AuditEnum.PROPERTY.getAudit(validationContext.getAnnotations()) != null;
        EPType propertyTypeUnboxed = eventType.getPropertyEPType(propertyInfoPair.getFirst().getPropertyName());
        EPType propertyType = JavaClassHelper.getBoxedType(propertyTypeUnboxed);
        this.evaluator = new ExprIdentNodeEvaluatorImpl(streamNum, propertyGetter, propertyType, this, (EventTypeSPI)eventType, validationContext.getStreamTypeService().isOptionalStreams(), audit);
        if (validationContext.getContextDescriptor() != null && !validationContext.isFilterExpression()) {
            EventType fromType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
            String contextPropertyName = validationContext.getContextDescriptor().getContextPropertyRegistry().getPartitionContextPropertyName(fromType, this.resolvedPropertyName);
            if (contextPropertyName != null) {
                EventTypeSPI contextType = (EventTypeSPI)validationContext.getContextDescriptor().getContextPropertyRegistry().getContextEventType();
                EPType contextPropertyType = JavaClassHelper.getBoxedType(contextType.getPropertyEPType(contextPropertyName));
                this.evaluator = new ExprIdentNodeEvaluatorContext(streamNum, contextPropertyType, contextType.getGetterSPI(contextPropertyName), (EventTypeSPI)eventType);
            }
        }
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public int getStreamId() {
        if (this.evaluator == null) {
            throw new IllegalStateException("Identifier expression has not been validated");
        }
        return this.evaluator.getStreamNum();
    }

    @Override
    public Integer getStreamReferencedIfAny() {
        return this.getStreamId();
    }

    @Override
    public String getRootPropertyNameIfAny() {
        return this.getResolvedPropertyNameRoot();
    }

    @Override
    public String getResolvedStreamName() {
        if (this.resolvedStreamName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedStreamName;
    }

    @Override
    public String getResolvedPropertyName() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedPropertyName;
    }

    @Override
    public String getResolvedPropertyNameRoot() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        if (this.resolvedPropertyName.indexOf(91) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(91));
        }
        if (this.resolvedPropertyName.indexOf(40) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(40));
        }
        if (this.resolvedPropertyName.indexOf(46) != -1) {
            return this.resolvedPropertyName.substring(0, this.resolvedPropertyName.indexOf(46));
        }
        return this.resolvedPropertyName;
    }

    public String toString() {
        return "unresolvedPropertyName=" + this.unresolvedPropertyName + " streamOrPropertyName=" + this.streamOrPropertyName + " resolvedPropertyName=" + this.resolvedPropertyName;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        ExprIdentNodeImpl.toPrecedenceFreeEPL(writer, this.streamOrPropertyName, this.unresolvedPropertyName, flags);
    }

    public static void toPrecedenceFreeEPL(StringWriter writer, String streamOrPropertyName, String unresolvedPropertyName, ExprNodeRenderableFlags flags) {
        if (streamOrPropertyName != null && flags.isWithStreamPrefix()) {
            writer.append(StringValue.unescapeDot(streamOrPropertyName)).append('.');
        }
        writer.append(StringValue.unescapeDot(StringValue.unescapeBacktick(unresolvedPropertyName)));
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprIdentNode)) {
            return false;
        }
        ExprIdentNode other = (ExprIdentNode)node;
        if (ignoreStreamPrefix && this.resolvedPropertyName != null && other.getResolvedPropertyName() != null && this.resolvedPropertyName.equals(other.getResolvedPropertyName())) {
            return true;
        }
        if (this.streamOrPropertyName != null ? !this.streamOrPropertyName.equals(other.getStreamOrPropertyName()) : other.getStreamOrPropertyName() != null) {
            return false;
        }
        return !(this.unresolvedPropertyName != null ? !this.unresolvedPropertyName.equals(other.getUnresolvedPropertyName()) : other.getUnresolvedPropertyName() != null);
    }

    @Override
    public ExprIdentNodeEvaluator getExprEvaluatorIdent() {
        return this.evaluator;
    }

    @Override
    public ExprEnumerationForgeDesc getEnumerationForge(StreamTypeService streamTypeService, ContextCompileTimeDescriptor contextDescriptor) {
        FragmentEventType fragmentEventType = this.evaluator.getEventType().getFragmentType(this.getResolvedPropertyName());
        if (fragmentEventType == null || fragmentEventType.isIndexed()) {
            return null;
        }
        ExprIdentNodeFragmentTypeEnumerationForge forge = new ExprIdentNodeFragmentTypeEnumerationForge(this.resolvedPropertyName, this.getStreamId(), fragmentEventType.getFragmentType(), this.evaluator.getEventType().getGetterSPI(this.resolvedPropertyName));
        return new ExprEnumerationForgeDesc(forge, streamTypeService.getIStreamOnly()[this.getStreamId()], -1);
    }
}

