/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.StringWriter;
import java.util.Collection;

public abstract class ExprNodeBase
implements ExprNode {
    private static final ExprNode[] EMPTY_EXPR_ARRAY = new ExprNode[0];
    private ExprNode[] childNodes = EMPTY_EXPR_ARRAY;

    public abstract void toPrecedenceFreeEPL(StringWriter var1, ExprNodeRenderableFlags var2);

    @Override
    public void accept(ExprNodeVisitor visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this);
            for (ExprNode childNode : this.childNodes) {
                childNode.accept(visitor);
            }
        }
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, null);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        if (visitor.isVisit(this)) {
            visitor.visit(this, parent);
            for (ExprNode childNode : this.childNodes) {
                childNode.acceptChildnodes(visitor, this);
            }
        }
    }

    @Override
    public final void addChildNode(ExprNode childNode) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddSingle(this.childNodes, childNode);
    }

    @Override
    public final void addChildNodes(Collection<ExprNode> childNodeColl) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddElements((Object)this.childNodes, childNodeColl);
    }

    @Override
    public final ExprNode[] getChildNodes() {
        return this.childNodes;
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
    }

    public void addChildNodeToFront(ExprNode childNode) {
        this.childNodes = (ExprNode[])CollectionUtil.arrayExpandAddElements((Object)new ExprNode[]{childNode}, this.childNodes);
    }

    @Override
    public void setChildNodes(ExprNode ... nodes) {
        this.childNodes = nodes;
    }

    @Override
    public void setChildNode(int index, ExprNode newNode) {
        this.childNodes[index] = newNode;
    }

    @Override
    public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence, ExprNodeRenderableFlags flags) {
        if (this.getPrecedence().getLevel() < parentPrecedence.getLevel()) {
            writer.write("(");
            this.toPrecedenceFreeEPL(writer, flags);
            writer.write(")");
        } else {
            this.toPrecedenceFreeEPL(writer, flags);
        }
    }

    protected static void checkValidated(ExprForge forge) {
        if (forge == null) {
            throw ExprNodeBase.checkValidatedException();
        }
    }

    protected static IllegalStateException checkValidatedException() {
        return new IllegalStateException("Expression has not been validated");
    }
}

