/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.expr.EPLMethodInvocationContext;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.EnumMethodResolver;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprWildcard;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalMethodContext;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamNumEnumCollEventForge;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamNumEnumSingleForge;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamNumEvent;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamNumEventTable;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamNumUnd;
import com.espertech.esper.common.internal.epl.expression.etc.ExprEvalStreamTable;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class ExprNodeUtilityResolve {
    public static ExprNodeUtilMethodDesc resolveMethodAllowWildcardAndStream(String className, EPTypeClass optionalClass, String methodName, List<ExprNode> parameters, boolean allowWildcard, EventType wildcardType, ExprNodeUtilResolveExceptionHandler exceptionHandler, String functionName, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        Method method;
        EPType[] paramTypes = new EPType[parameters.size()];
        ExprForge[] childForges = new ExprForge[parameters.size()];
        int count = 0;
        boolean[] allowEventBeanType = new boolean[parameters.size()];
        boolean[] allowEventBeanCollType = new boolean[parameters.size()];
        ExprForge[] childEvalsEventBeanReturnTypesForges = new ExprForge[parameters.size()];
        boolean allConstants = true;
        for (ExprNode childNode : parameters) {
            if (!EnumMethodResolver.isEnumerationMethod(methodName, services.getClasspathImportServiceCompileTime()) && childNode instanceof ExprLambdaGoesNode) {
                throw new ExprValidationException("Unrecognized lambda-expression encountered as parameter to UDF or static method '" + methodName + "'");
            }
            if (childNode instanceof ExprWildcard) {
                if (wildcardType == null || !allowWildcard) {
                    throw new ExprValidationException("Failed to resolve wildcard parameter to a given event type");
                }
                childForges[count] = new ExprEvalStreamNumUnd(0, wildcardType.getUnderlyingEPType());
                childEvalsEventBeanReturnTypesForges[count] = new ExprEvalStreamNumEvent(0);
                paramTypes[count] = wildcardType.getUnderlyingEPType();
                allowEventBeanType[count] = true;
                allConstants = false;
                ++count;
                continue;
            }
            if (childNode instanceof ExprStreamUnderlyingNode) {
                ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)childNode;
                TableMetaData tableMetadata = services.getTableCompileTimeResolver().resolveTableFromEventType(und.getEventType());
                if (tableMetadata == null) {
                    childForges[count] = childNode.getForge();
                    childEvalsEventBeanReturnTypesForges[count] = new ExprEvalStreamNumEvent(und.getStreamId());
                } else {
                    childForges[count] = new ExprEvalStreamTable(und.getStreamId(), und.getEventType().getUnderlyingEPType(), tableMetadata);
                    childEvalsEventBeanReturnTypesForges[count] = new ExprEvalStreamNumEventTable(und.getStreamId(), tableMetadata);
                }
                paramTypes[count] = childForges[count].getEvaluationType();
                allowEventBeanType[count] = true;
                allConstants = false;
                ++count;
                continue;
            }
            if (childNode.getForge() instanceof ExprEnumerationForge) {
                ExprEnumerationForge enumeration = (ExprEnumerationForge)((Object)childNode.getForge());
                EventType eventType = enumeration.getEventTypeSingle(statementRawInfo, services);
                childForges[count] = childNode.getForge();
                paramTypes[count] = childForges[count].getEvaluationType();
                allConstants = false;
                if (eventType != null) {
                    childEvalsEventBeanReturnTypesForges[count] = new ExprEvalStreamNumEnumSingleForge(enumeration);
                    allowEventBeanType[count] = true;
                    ++count;
                    continue;
                }
                EventType eventTypeColl = enumeration.getEventTypeCollection(statementRawInfo, services);
                if (eventTypeColl != null) {
                    childEvalsEventBeanReturnTypesForges[count] = new ExprEvalStreamNumEnumCollEventForge(enumeration);
                    allowEventBeanCollType[count] = true;
                    ++count;
                    continue;
                }
            }
            paramTypes[count] = childNode.getForge().getEvaluationType();
            childForges[count] = childNode.getForge();
            ++count;
            if (childNode.getForge().getForgeConstantType().isCompileTimeConstant()) continue;
            allConstants = false;
        }
        try {
            method = optionalClass != null ? services.getClasspathImportServiceCompileTime().resolveMethod(optionalClass.getType(), methodName, paramTypes, allowEventBeanType) : services.getClasspathImportServiceCompileTime().resolveMethodOverloadChecked(className, methodName, paramTypes, allowEventBeanType, allowEventBeanCollType, services.getClassProvidedClasspathExtension());
        }
        catch (Exception e) {
            throw exceptionHandler.handle(e);
        }
        if (CollectionUtil.isAnySet(allowEventBeanType)) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (!allowEventBeanType[i] || !ExprNodeUtilityResolve.checkMethodEnumerableParameter(method, i, EventBean.class)) continue;
                childForges[i] = childEvalsEventBeanReturnTypesForges[i];
            }
        }
        if (CollectionUtil.isAnySet(allowEventBeanCollType)) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (!allowEventBeanCollType[i] || !ExprNodeUtilityResolve.checkMethodEnumerableParameter(method, i, Collection.class)) continue;
                childForges[i] = childEvalsEventBeanReturnTypesForges[i];
            }
        }
        if (!method.isVarArgs() && method.getParameterTypes().length > 0 && method.getParameterTypes()[method.getParameterTypes().length - 1] == EPLMethodInvocationContext.class) {
            ExprEvalMethodContext node = new ExprEvalMethodContext(functionName);
            childForges = (ExprForge[])CollectionUtil.arrayExpandAddSingle(childForges, node);
        }
        if (method.isVarArgs()) {
            int numMethodParams = method.getParameterTypes().length;
            if (numMethodParams > 1 && method.getParameterTypes()[numMethodParams - 2] == EPLMethodInvocationContext.class) {
                ExprForge[] rewrittenForges = new ExprForge[childForges.length + 1];
                System.arraycopy(childForges, 0, rewrittenForges, 0, numMethodParams - 2);
                ExprEvalMethodContext node = new ExprEvalMethodContext(functionName);
                rewrittenForges[numMethodParams - 2] = node;
                System.arraycopy(childForges, numMethodParams - 2, rewrittenForges, numMethodParams - 1, childForges.length - (numMethodParams - 2));
                childForges = rewrittenForges;
            }
            childForges = ExprNodeUtilityMake.makeVarargArrayForges(method, childForges);
        }
        boolean localInlinedClass = services.getClassProvidedClasspathExtension().isLocalInlinedClass(method.getDeclaringClass());
        return new ExprNodeUtilMethodDesc(allConstants, childForges, method, optionalClass, localInlinedClass);
    }

    private static boolean checkMethodEnumerableParameter(Method method, int parameterNumber, Class expected) {
        int numParameters = method.getParameterTypes().length;
        if (!method.isVarArgs() || numParameters - 1 >= parameterNumber) {
            return method.getParameterTypes()[parameterNumber] == expected;
        }
        return method.getParameterTypes()[numParameters - 1] == expected;
    }
}

