/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.type.RangeParameter;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNumberSetRange
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExprNumberSetRange.class);
    public static final String METHOD_HANDLENUMBERSETRANGELOWERNULL = "handleNumberSetRangeLowerNull";
    public static final String METHOD_HANDLENUMBERSETRANGEUPPERNULL = "handleNumberSetRangeUpperNull";
    private transient ExprEvaluator[] evaluators;

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(":");
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return RangeParameter.EPTYPE;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return this;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.values()[Math.max(this.getChildNodes()[0].getForge().getForgeConstantType().ordinal(), this.getChildNodes()[1].getForge().getForgeConstantType().ordinal())];
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprNumberSetRange;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.evaluators = ExprNodeUtilityQuery.getEvaluatorsNoCompile(this.getChildNodes());
        EPType typeOne = this.getChildNodes()[0].getForge().getEvaluationType();
        EPType typeTwo = this.getChildNodes()[1].getForge().getEvaluationType();
        if (!JavaClassHelper.isNumericNonFP(typeOne) || !JavaClassHelper.isNumericNonFP(typeTwo)) {
            throw new ExprValidationException("Range operator requires integer-type parameters");
        }
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLower = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object valueUpper = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueLower == null) {
            ExprNumberSetRange.handleNumberSetRangeLowerNull();
            valueLower = 0;
        }
        if (valueUpper == null) {
            ExprNumberSetRange.handleNumberSetRangeUpperNull();
            valueUpper = Integer.MAX_VALUE;
        }
        int intValueLower = ((Number)valueLower).intValue();
        int intValueUpper = ((Number)valueUpper).intValue();
        return new RangeParameter(intValueLower, intValueUpper);
    }

    public static void handleNumberSetRangeLowerNull() {
        log.warn("Null value returned for lower bounds value in range parameter, using zero as lower bounds");
    }

    public static void handleNumberSetRangeUpperNull() {
        log.warn("Null value returned for upper bounds value in range parameter, using max as upper bounds");
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge lowerValue = this.getChildNodes()[0].getForge();
        ExprForge upperValue = this.getChildNodes()[1].getForge();
        EPTypeClass lowerType = (EPTypeClass)lowerValue.getEvaluationType();
        EPTypeClass upperType = (EPTypeClass)upperValue.getEvaluationType();
        CodegenMethod methodNode = codegenMethodScope.makeChild(RangeParameter.EPTYPE, ExprNumberSetRange.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(lowerType, "valueLower", lowerValue.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope)).declareVar(upperType, "valueUpper", upperValue.evaluateCodegen(requiredType, methodNode, exprSymbol, codegenClassScope));
        if (!lowerType.getType().isPrimitive()) {
            block.ifRefNull("valueLower").staticMethod(ExprNumberSetRange.class, METHOD_HANDLENUMBERSETRANGELOWERNULL, new CodegenExpression[0]).assignRef("valueLower", CodegenExpressionBuilder.constant(0)).blockEnd();
        }
        if (!upperType.getType().isPrimitive()) {
            block.ifRefNull("valueUpper").staticMethod(ExprNumberSetRange.class, METHOD_HANDLENUMBERSETRANGEUPPERNULL, new CodegenExpression[0]).assignRef("valueUpper", CodegenExpressionBuilder.enumValue(Integer.class, "MAX_VALUE")).blockEnd();
        }
        block.methodReturn(CodegenExpressionBuilder.newInstance(RangeParameter.EPTYPE, SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(CodegenExpressionBuilder.ref("valueLower"), lowerType), SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(CodegenExpressionBuilder.ref("valueUpper"), upperType)));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

