/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportEPTypeUtil;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprSubstitutionNode
extends ExprNodeBase
implements ExprForge,
ExprNodeDeployTimeConst {
    private String optionalName;
    private ClassDescriptor optionalType;
    private EPTypeClass type = EPTypePremade.OBJECT.getEPType();
    private CodegenExpressionField field;

    public ExprSubstitutionNode(String optionalName, ClassDescriptor optionalType) {
        this.optionalName = optionalName;
        this.optionalType = optionalType;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.optionalType != null) {
            Class clazz = null;
            try {
                clazz = JavaClassHelper.getClassForName(this.optionalType.getClassIdentifier(), validationContext.getClasspathImportService().getClassForNameProvider());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = JavaClassHelper.getClassForSimpleName(this.optionalType.getClassIdentifier(), validationContext.getClasspathImportService().getClassForNameProvider());
            }
            if (clazz == null) {
                try {
                    clazz = validationContext.getClasspathImportService().resolveClass(this.optionalType.getClassIdentifier(), false, validationContext.getClassProvidedClasspathExtension());
                }
                catch (ClasspathImportException e) {
                    throw new ExprValidationException("Failed to resolve type '" + this.optionalType.getClassIdentifier() + "': " + e.getMessage(), e);
                }
            }
            if (!this.getOptionalType().isArrayOfPrimitive()) {
                clazz = JavaClassHelper.getBoxedType(clazz);
            } else if (!clazz.isPrimitive()) {
                throw new ExprValidationException("Invalid use of the 'primitive' keyword for non-primitive type '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "'");
            }
            this.type = ClasspathImportEPTypeUtil.parameterizeType(true, clazz, this.optionalType, (ClasspathImportService)validationContext.getClasspathImportService(), validationContext.getClassProvidedClasspathExtension());
        }
        return null;
    }

    public String getOptionalName() {
        return this.optionalName;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("?");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprSubstitutionNode;
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        return this.asField(codegenClassScope);
    }

    @Override
    public CodegenExpression codegenGetDeployTimeConstValue(CodegenClassScope classScope) {
        return this.asField(classScope);
    }

    @Override
    public EPTypeClass getEvaluationType() {
        return this.type;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.DEPLOYCONST;
    }

    @Override
    public ExprNodeRenderable getForgeRenderable() {
        return new ExprNodeRenderable(){

            @Override
            public void toEPL(StringWriter writer, ExprPrecedenceEnum parentPrecedence, ExprNodeRenderableFlags flags) {
                writer.append("?");
            }
        };
    }

    public ClassDescriptor getOptionalType() {
        return this.optionalType;
    }

    public EPTypeClass getResolvedType() {
        return this.type;
    }

    @Override
    public void renderForFilterPlan(StringBuilder out) {
        out.append("substitution parameter");
        if (this.optionalName != null) {
            out.append(" name '").append(this.optionalName).append("'");
        }
        if (this.optionalType != null) {
            out.append(" type '").append(this.optionalType.toEPL()).append("'");
        }
    }

    private CodegenExpressionField asField(CodegenClassScope classScope) {
        if (this.field == null) {
            this.field = CodegenExpressionBuilder.field(classScope.addSubstitutionParameter(this.optionalName, this.type));
        }
        return this.field;
    }
}

