/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.declared.runtime;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.compile.stage1.spec.ExpressionDeclItem;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.declared.core.ExprDeclaredCacheKeyGlobal;
import com.espertech.esper.common.internal.epl.expression.declared.core.ExprDeclaredCacheKeyLocalCodegenField;

public class ExpressionDeployTimeResolver {
    public static CodegenExpressionField makeRuntimeCacheKeyField(ExpressionDeclItem expression, CodegenClassScope classScope, Class generator) {
        if (expression.getVisibility() == NameAccessModifier.TRANSIENT) {
            return classScope.getPackageScope().addOrGetFieldSharable(new ExprDeclaredCacheKeyLocalCodegenField(expression.getName()));
        }
        CodegenMethod keyInit = classScope.getPackageScope().getInitMethod().makeChild(ExprDeclaredCacheKeyGlobal.EPTYPE, generator, (CodegenScope)classScope).addParam(EPStatementInitServices.EPTYPE, EPStatementInitServices.REF.getRef());
        keyInit.getBlock().declareVar(EPTypePremade.STRING.getEPType(), "deploymentId", CodegenExpressionBuilder.staticMethod(ExpressionDeployTimeResolver.class, "resolveDeploymentId", CodegenExpressionBuilder.constant(expression.getName()), CodegenExpressionBuilder.constant((Object)expression.getVisibility()), CodegenExpressionBuilder.constant(expression.getModuleName()), EPStatementInitServices.REF)).methodReturn(CodegenExpressionBuilder.newInstance(ExprDeclaredCacheKeyGlobal.EPTYPE, CodegenExpressionBuilder.ref("deploymentId"), CodegenExpressionBuilder.constant(expression.getName())));
        return classScope.getPackageScope().addFieldUnshared(true, ExprDeclaredCacheKeyGlobal.EPTYPE, CodegenExpressionBuilder.localMethod(keyInit, EPStatementInitServices.REF));
    }

    public static String resolveDeploymentId(String expressionName, NameAccessModifier visibility, String optionalModuleName, EPStatementInitServices services) {
        String deploymentId;
        if (visibility == NameAccessModifier.PRECONFIGURED) {
            deploymentId = null;
        } else if (visibility == NameAccessModifier.PRIVATE) {
            deploymentId = services.getDeploymentId();
        } else if (visibility == NameAccessModifier.PUBLIC) {
            deploymentId = services.getExprDeclaredPathRegistry().getDeploymentId(expressionName, optionalModuleName);
            if (deploymentId == null) {
                throw new EPException("Failed to resolve path expression '" + expressionName + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized visibility " + (Object)((Object)visibility));
        }
        return deploymentId;
    }
}

