/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotEval;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForgeGetCollection;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ExprDotForgeGetCollectionEval
implements ExprDotEval {
    private final ExprDotForgeGetCollection forge;
    private final ExprEvaluator indexExpression;

    public ExprDotForgeGetCollectionEval(ExprDotForgeGetCollection forge, ExprEvaluator indexExpression) {
        this.forge = forge;
        this.indexExpression = indexExpression;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        Object index = this.indexExpression.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (!(index instanceof Integer)) {
            return null;
        }
        int indexNum = (Integer)index;
        return ExprDotForgeGetCollectionEval.collectionElementAt(target, indexNum);
    }

    public static Object collectionElementAt(Object target, int indexNum) {
        Collection collection = (Collection)target;
        if (collection.size() <= indexNum) {
            return null;
        }
        if (collection instanceof List) {
            return ((List)collection).get(indexNum);
        }
        Iterator it = collection.iterator();
        for (int count = 0; count < indexNum && it.hasNext(); ++count) {
            it.next();
        }
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public EPChainableType getTypeInfo() {
        return this.forge.getTypeInfo();
    }

    @Override
    public ExprDotForge getDotForge() {
        return this.forge;
    }

    public static CodegenExpression codegen(ExprDotForgeGetCollection forge, CodegenExpression inner, EPTypeClass innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild((EPTypeClass)EPChainableTypeHelper.getNormalizedEPType(forge.getTypeInfo()), ExprDotForgeGetCollectionEval.class, (CodegenScope)codegenClassScope).addParam(innerType, "target");
        CodegenBlock block = methodNode.getBlock();
        if (!innerType.getType().isPrimitive()) {
            block.ifRefNullReturnNull("target");
        }
        EPTypeClass targetType = EPChainableTypeHelper.getCodegenReturnType(forge.getTypeInfo());
        block.declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "index", forge.getIndexExpression().evaluateCodegen(EPTypePremade.INTEGERPRIMITIVE.getEPType(), methodNode, exprSymbol, codegenClassScope)).methodReturn(CodegenLegoCast.castSafeFromObjectType(targetType, CodegenExpressionBuilder.staticMethod(ExprDotForgeGetCollectionEval.class, "collectionElementAt", CodegenExpressionBuilder.ref("target"), CodegenExpressionBuilder.ref("index"))));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }
}

