/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.dot.walk;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.specmapper.ASTAggregationHelper;
import com.espertech.esper.common.internal.compile.stage1.specmapper.StatementSpecMapContext;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMinMaxAggrNode;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableArray;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableCall;
import com.espertech.esper.common.internal.epl.expression.chain.ChainableName;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.MinMaxTypeEnum;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredHelper;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNodeImpl;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeImpl;
import com.espertech.esper.common.internal.epl.expression.dot.walk.ChainableWalkNotAPropertyException;
import com.espertech.esper.common.internal.epl.expression.dot.walk.DotEscaper;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprMinMaxRowNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeKeys;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeSubprop;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNodeTopLevel;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNodeImpl;
import com.espertech.esper.common.internal.epl.script.core.ExprNodeScript;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableUtil;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.settings.ClasspathImportUndefinedException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.ValidationException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public class ChainableWalkHelper {
    public static ExprNode processDot(boolean useChainAsIs, boolean resolveObjects, List<Chainable> chain, StatementSpecMapContext mapContext) {
        ExprNode resolved;
        if (chain.isEmpty()) {
            throw new IllegalArgumentException("Empty chain");
        }
        Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction = chainSpec -> {
            ExprDotNodeImpl dotNode = new ExprDotNodeImpl((List<Chainable>)chainSpec, mapContext.getConfiguration().getCompiler().getExpression().isDuckTyping(), mapContext.getConfiguration().getCompiler().getExpression().isUdfCache());
            VariableMetaData variable = dotNode.isVariableOpGetName(mapContext.getVariableCompileTimeResolver());
            if (variable != null) {
                mapContext.getVariableNames().add(variable.getVariableName());
            }
            return dotNode;
        };
        if (resolveObjects && (resolved = ChainableWalkHelper.resolveObject(chain, mapContext, dotNodeFunction)) != null) {
            return resolved;
        }
        boolean plain = ChainableWalkHelper.determinePlainProperty(chain);
        if (plain) {
            return ChainableWalkHelper.handlePlain(chain, dotNodeFunction, useChainAsIs);
        }
        return ChainableWalkHelper.handleNonPlain(chain, dotNodeFunction);
    }

    private static ExprNode resolveObject(List<Chainable> chain, StatementSpecMapContext mapContext, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        ExprNode aggregationNode;
        Pair<ExprNode, ExprTableAccessNode> nodes;
        Chainable chainFirst = chain.get(0);
        String chainFirstName = chainFirst.getRootNameOrEmptyString();
        List<ExprNode> chainFirstParams = chainFirst.getParametersOrEmpty();
        ExprNodeScript scriptNode = ExprDeclaredHelper.getExistsScript(mapContext.getConfiguration().getCompiler().getScripts().getDefaultDialect(), chainFirstName, chainFirstParams, mapContext.getScripts(), mapContext.getMapEnv());
        if (scriptNode != null) {
            return ChainableWalkHelper.handleScript(scriptNode, chain, dotNodeFunction);
        }
        TableMetaData table = mapContext.getTableCompileTimeResolver().resolve(chainFirstName);
        if (table != null && (nodes = ChainableWalkHelper.handleTable(chain, table, dotNodeFunction)) != null) {
            mapContext.getTableExpressions().add(nodes.getSecond());
            return nodes.getFirst();
        }
        VariableMetaData variable = mapContext.getVariableCompileTimeResolver().resolve(chainFirstName);
        if (variable != null) {
            mapContext.getVariableNames().add(variable.getVariableName());
            return ChainableWalkHelper.handleVariable(chain, variable, mapContext, dotNodeFunction);
        }
        Pair<Class, ClasspathImportSingleRowDesc> singleRow = ChainableWalkHelper.trySingleRow(mapContext, chainFirstName);
        if (singleRow != null) {
            return ChainableWalkHelper.handleSingleRow(singleRow, chain);
        }
        ExprNode singleRowExtNode = mapContext.getClasspathImportService().resolveSingleRowExtendedBuiltin(chainFirstName);
        if (singleRowExtNode != null) {
            return ChainableWalkHelper.handleSingleRowExt(singleRowExtNode, chain, dotNodeFunction);
        }
        Pair<ExprDeclaredNodeImpl, StatementSpecMapContext> declaredExpr = ExprDeclaredHelper.getExistsDeclaredExpr(chainFirstName, chainFirstParams, mapContext.getExpressionDeclarations().values(), mapContext.getContextCompileTimeDescriptor(), mapContext.getMapEnv(), mapContext.getPlugInAggregations(), mapContext.getScripts());
        if (declaredExpr != null) {
            mapContext.add(declaredExpr.getSecond());
            return ChainableWalkHelper.handleDeclaredExpr(declaredExpr.getFirst(), chain, dotNodeFunction);
        }
        ExprNode exprNode = aggregationNode = chainFirst instanceof ChainableName ? null : ASTAggregationHelper.tryResolveAsAggregation(mapContext.getClasspathImportService(), chainFirst.isDistinct(), chainFirstName, mapContext.getPlugInAggregations(), mapContext.getClassProvidedClasspathExtension());
        if (aggregationNode != null) {
            return ChainableWalkHelper.handleAggregation(aggregationNode, chain, dotNodeFunction);
        }
        if (mapContext.getContextCompileTimeDescriptor() != null && mapContext.getContextCompileTimeDescriptor().getContextPropertyRegistry().isContextPropertyPrefix(chainFirstName)) {
            return ChainableWalkHelper.handleContextProp(chain, dotNodeFunction);
        }
        String chainFirstLowerCase = chainFirstName.toLowerCase(Locale.ENGLISH);
        if (!(chainFirst instanceof ChainableName) && (chainFirstLowerCase.equals("max") || chainFirstLowerCase.equals("min") || chainFirstLowerCase.equals("fmax") || chainFirstLowerCase.equals("fmin"))) {
            return ChainableWalkHelper.handleMinMax(chainFirstLowerCase, chain, dotNodeFunction);
        }
        List<Chainable> classChain = ChainableWalkHelper.handleClassPrefixedNonProp(mapContext, chain);
        if (classChain != null) {
            return dotNodeFunction.apply(classChain);
        }
        return null;
    }

    private static ExprNode handleContextProp(List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        try {
            String subproperty = ChainableWalkHelper.toPlainPropertyString(chain, 1);
            return new ExprContextPropertyNodeImpl(subproperty);
        }
        catch (ChainableWalkNotAPropertyException subproperty) {
            for (int i = chain.size() - 1; i > 1; --i) {
                List<Chainable> subchain = chain.subList(1, i);
                try {
                    String subproperty2 = ChainableWalkHelper.toPlainPropertyString(subchain, 0);
                    ExprContextPropertyNodeImpl contextProperty = new ExprContextPropertyNodeImpl(subproperty2);
                    List<Chainable> calls = chain.subList(i, chain.size());
                    ExprNode dot = dotNodeFunction.apply(calls);
                    dot.addChildNode(contextProperty);
                    return dot;
                }
                catch (ChainableWalkNotAPropertyException chainableWalkNotAPropertyException) {
                    continue;
                }
            }
            return null;
        }
    }

    private static ExprNode handleSingleRowExt(ExprNode singleRowExtNode, List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        singleRowExtNode.addChildNodes(chain.get(0).getParametersOrEmpty());
        if (chain.size() == 1) {
            return singleRowExtNode;
        }
        ArrayList<Chainable> spec = new ArrayList<Chainable>(chain.subList(1, chain.size()));
        ExprNode dot = dotNodeFunction.apply(spec);
        dot.addChildNode(singleRowExtNode);
        return dot;
    }

    private static ExprNode handleDeclaredExpr(ExprDeclaredNodeImpl node, List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        if (chain.size() == 1) {
            return node;
        }
        ArrayList<Chainable> spec = new ArrayList<Chainable>(chain.subList(1, chain.size()));
        ExprNode dot = dotNodeFunction.apply(spec);
        dot.addChildNode(node);
        return dot;
    }

    private static ExprNode handleMinMax(String chainFirstLowerCase, List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        ExprNode node = ChainableWalkHelper.handleMinMaxNode(chainFirstLowerCase, chain.get(0));
        if (chain.size() == 1) {
            return node;
        }
        ArrayList<Chainable> spec = new ArrayList<Chainable>(chain.subList(1, chain.size()));
        ExprNode dot = dotNodeFunction.apply(spec);
        dot.addChildNode(node);
        return dot;
    }

    private static ExprNode handleMinMaxNode(String chainFirstLowerCase, Chainable spec) {
        MinMaxTypeEnum minMaxTypeEnum;
        boolean filtered = chainFirstLowerCase.startsWith("f");
        if (chainFirstLowerCase.equals("min") || chainFirstLowerCase.equals("fmin")) {
            minMaxTypeEnum = MinMaxTypeEnum.MIN;
        } else if (chainFirstLowerCase.equals("max") || chainFirstLowerCase.equals("fmax")) {
            minMaxTypeEnum = MinMaxTypeEnum.MAX;
        } else {
            throw new ValidationException("Uncountered unrecognized min or max node '" + spec.getRootNameOrEmptyString() + "'");
        }
        List<ExprNode> args = spec.getParametersOrEmpty();
        boolean distinct = spec.isDistinct();
        int numArgsPositional = ExprAggregateNodeUtil.countPositionalArgs(args);
        if (numArgsPositional > 1 && spec.isDistinct() && !filtered) {
            throw new ValidationException("The distinct keyword is not valid in per-row min and max functions with multiple sub-expressions");
        }
        ExprNodeBase minMaxNode = !distinct && numArgsPositional > 1 && !filtered ? new ExprMinMaxRowNode(minMaxTypeEnum) : new ExprMinMaxAggrNode(distinct, minMaxTypeEnum, filtered, false);
        minMaxNode.addChildNodes(args);
        return minMaxNode;
    }

    private static ExprNode handleSingleRow(Pair<Class, ClasspathImportSingleRowDesc> singleRow, List<Chainable> chain) {
        ArrayList<Chainable> spec = new ArrayList<Chainable>();
        String methodName = singleRow.getSecond().getMethodName();
        String nameUsed = chain.get(0).getRootNameOrEmptyString();
        ChainableCall call = new ChainableCall(methodName, chain.get(0).getParametersOrEmpty());
        spec.add(call);
        spec.addAll(chain.subList(1, chain.size()));
        return new ExprPlugInSingleRowNode(nameUsed, singleRow.getFirst(), spec, singleRow.getSecond());
    }

    private static Pair<Class, ClasspathImportSingleRowDesc> trySingleRow(StatementSpecMapContext mapContext, String chainFirstName) {
        try {
            return mapContext.getClasspathImportService().resolveSingleRow(chainFirstName, mapContext.getClassProvidedClasspathExtension());
        }
        catch (ClasspathImportException | ClasspathImportUndefinedException ex) {
            return null;
        }
    }

    private static ExprNode handleScript(ExprNodeScript scriptNode, List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        if (chain.size() == 1) {
            return scriptNode;
        }
        List<Chainable> subchain = chain.subList(1, chain.size());
        ExprDotNode dot = dotNodeFunction.apply(subchain);
        dot.addChildNode(scriptNode);
        return dot;
    }

    private static ExprNode handleVariable(List<Chainable> chain, VariableMetaData variable, StatementSpecMapContext mapContext, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        String message = VariableUtil.checkVariableContextName(mapContext.getContextName(), variable);
        if (message != null) {
            throw new ValidationException(message);
        }
        ExprVariableNodeImpl rootNode = new ExprVariableNodeImpl(variable, null);
        if (chain.size() == 1) {
            return rootNode;
        }
        if (chain.size() == 2 && chain.get(1) instanceof ChainableName) {
            return new ExprVariableNodeImpl(variable, chain.get(1).getRootNameOrEmptyString());
        }
        List<Chainable> subchain = chain.subList(1, chain.size());
        ExprDotNode dot = dotNodeFunction.apply(subchain);
        dot.addChildNode(rootNode);
        return dot;
    }

    private static List<Chainable> handleClassPrefixedNonProp(StatementSpecMapContext mapContext, List<Chainable> chain) {
        String classNameCandidate;
        int depth;
        int indexOfLastProp = ChainableWalkHelper.getClassIndexOfLastProp(chain);
        if (indexOfLastProp == -1 || indexOfLastProp == chain.size() - 1) {
            return null;
        }
        int depthFound = -1;
        for (depth = indexOfLastProp; depth > 0; --depth) {
            classNameCandidate = ChainableWalkHelper.buildClassName(chain, depth);
            try {
                mapContext.getClasspathImportService().resolveClass(classNameCandidate, false, mapContext.getClassProvidedClasspathExtension());
                depthFound = depth;
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (depthFound == -1) {
            return null;
        }
        if (depth == indexOfLastProp) {
            classNameCandidate = ChainableWalkHelper.buildClassName(chain, depth);
            return ChainableWalkHelper.buildSubchainWClassname(classNameCandidate, depth + 1, chain);
        }
        classNameCandidate = ChainableWalkHelper.buildClassName(chain, depth + 1);
        return ChainableWalkHelper.buildSubchainWClassname(classNameCandidate, depth + 2, chain);
    }

    private static List<Chainable> buildSubchainWClassname(String classNameCandidate, int depth, List<Chainable> chain) {
        ArrayList<Chainable> newChain = new ArrayList<Chainable>(2);
        newChain.add(new ChainableName(classNameCandidate));
        newChain.addAll(chain.subList(depth, chain.size()));
        return newChain;
    }

    private static int getClassIndexOfLastProp(List<Chainable> chain) {
        int indexOfLastProp = -1;
        int i = 0;
        while (i < chain.size()) {
            Chainable spec = chain.get(i);
            if (!(spec instanceof ChainableName) || spec.isOptional()) {
                return indexOfLastProp;
            }
            if (chain.size() > i + 1 && chain.get(i + 1) instanceof ChainableArray) {
                return indexOfLastProp;
            }
            indexOfLastProp = i++;
        }
        return indexOfLastProp;
    }

    private static String buildClassName(List<Chainable> chain, int depthInclusive) {
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        for (int i = 0; i < depthInclusive + 1; ++i) {
            builder.append(delimiter);
            builder.append(chain.get(i).getRootNameOrEmptyString());
            delimiter = ".";
        }
        return builder.toString();
    }

    private static ExprNode handlePlain(List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction, boolean useChainAsIs) {
        Chainable first = chain.get(0);
        if (chain.size() == 1 || ChainableWalkHelper.isArrayProperty(first, chain.get(1)) || first.isOptional() || ChainableWalkHelper.isMappedProperty(first)) {
            if (useChainAsIs) {
                return dotNodeFunction.apply(chain);
            }
            String propertyName = null;
            try {
                propertyName = ChainableWalkHelper.toPlainPropertyString(chain, 0);
            }
            catch (ChainableWalkNotAPropertyException e) {
                throw new IllegalArgumentException(e);
            }
            return new ExprIdentNodeImpl(propertyName);
        }
        String leadingIdentifier = chain.get(0).getRootNameOrEmptyString();
        String streamOrNestedPropertyName = DotEscaper.escapeDot(leadingIdentifier);
        String propertyName = null;
        try {
            propertyName = ChainableWalkHelper.toPlainPropertyString(chain, 1);
        }
        catch (ChainableWalkNotAPropertyException e) {
            throw new IllegalArgumentException(e);
        }
        return new ExprIdentNodeImpl(propertyName, streamOrNestedPropertyName);
    }

    private static boolean isArrayProperty(Chainable chainable, Chainable next) {
        if (!(next instanceof ChainableArray)) {
            return false;
        }
        ChainableArray array = (ChainableArray)next;
        return chainable instanceof ChainableName && ChainableWalkHelper.isSingleParameterConstantOfType(array.getIndexes(), Integer.class);
    }

    private static boolean isMappedProperty(Chainable chainable) {
        if (!(chainable instanceof ChainableCall)) {
            return false;
        }
        ChainableCall call = (ChainableCall)chainable;
        return ChainableWalkHelper.isSingleParameterConstantOfType(call.getParameters(), String.class);
    }

    private static ExprNode handleAggregation(ExprNode aggregationNode, List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        ExprNode exprNode;
        Chainable firstSpec = chain.remove(0);
        aggregationNode.addChildNodes(firstSpec.getParametersOrEmpty());
        if (chain.isEmpty()) {
            exprNode = aggregationNode;
        } else {
            exprNode = dotNodeFunction.apply(chain);
            exprNode.addChildNode(aggregationNode);
        }
        return exprNode;
    }

    private static ExprNode handleNonPlain(List<Chainable> chain, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        if (chain.size() == 1) {
            return dotNodeFunction.apply(chain);
        }
        int indexOfLastProp = ChainableWalkHelper.getClassIndexOfLastProp(chain);
        if (indexOfLastProp != -1 && indexOfLastProp < chain.size() - 1) {
            String classNameCandidate = ChainableWalkHelper.buildClassName(chain, indexOfLastProp);
            chain = ChainableWalkHelper.buildSubchainWClassname(classNameCandidate, indexOfLastProp + 1, chain);
            return dotNodeFunction.apply(chain);
        }
        return dotNodeFunction.apply(chain);
    }

    private static boolean determinePlainProperty(List<Chainable> chain) {
        Chainable previous = null;
        for (Chainable spec : chain) {
            ChainableCall call;
            if (spec instanceof ChainableArray) {
                ChainableArray array = (ChainableArray)spec;
                if (!ChainableWalkHelper.isSingleParameterConstantOfType(array.getIndexes(), Integer.class)) {
                    return false;
                }
                if (previous instanceof ChainableArray) {
                    return false;
                }
            }
            if (spec instanceof ChainableCall && !ChainableWalkHelper.isSingleParameterConstantOfType((call = (ChainableCall)spec).getParameters(), String.class)) {
                return false;
            }
            previous = spec;
        }
        return true;
    }

    private static Pair<ExprNode, ExprTableAccessNode> handleTable(List<Chainable> chain, TableMetaData table, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        if (chain.size() == 1) {
            ExprTableAccessNodeTopLevel node = new ExprTableAccessNodeTopLevel(table.getTableName());
            return new Pair<ExprNode, ExprTableAccessNode>(node, node);
        }
        if (chain.get(1) instanceof ChainableArray) {
            List<ExprNode> tableKeys = ((ChainableArray)chain.get(1)).getIndexes();
            return ChainableWalkHelper.handleTableSubchain(tableKeys, chain.subList(2, chain.size()), table, dotNodeFunction);
        }
        return ChainableWalkHelper.handleTableSubchain(Collections.emptyList(), chain.subList(1, chain.size()), table, dotNodeFunction);
    }

    private static Pair<ExprNode, ExprTableAccessNode> handleTableSubchain(List<ExprNode> tableKeys, List<Chainable> chain, TableMetaData table, Function<List<Chainable>, ExprDotNodeImpl> dotNodeFunction) {
        if (chain.isEmpty()) {
            ExprTableAccessNodeTopLevel node = new ExprTableAccessNodeTopLevel(table.getTableName());
            node.addChildNodes(tableKeys);
            return new Pair<ExprNode, ExprTableAccessNode>(node, node);
        }
        String columnOrOtherName = chain.get(0).getRootNameOrEmptyString();
        TableMetadataColumn tableColumn = table.getColumns().get(columnOrOtherName);
        if (tableColumn != null && table.isKeyed() && tableKeys.isEmpty()) {
            return null;
        }
        if (chain.size() == 1) {
            if (chain.get(0) instanceof ChainableName) {
                ExprTableAccessNodeSubprop node = new ExprTableAccessNodeSubprop(table.getTableName(), columnOrOtherName);
                node.addChildNodes(tableKeys);
                return new Pair<ExprNode, ExprTableAccessNode>(node, node);
            }
            if (columnOrOtherName.toLowerCase(Locale.ENGLISH).equals("keys")) {
                ExprTableAccessNodeKeys node = new ExprTableAccessNodeKeys(table.getTableName());
                node.addChildNodes(tableKeys);
                return new Pair<ExprNode, ExprTableAccessNode>(node, node);
            }
            throw new ValidationException("Invalid use of table '" + table.getTableName() + "', unrecognized use of function '" + columnOrOtherName + "', expected 'keys()'");
        }
        ExprTableAccessNodeSubprop node = new ExprTableAccessNodeSubprop(table.getTableName(), columnOrOtherName);
        node.addChildNodes(tableKeys);
        List<Chainable> subchain = chain.subList(1, chain.size());
        ExprNode exprNode = dotNodeFunction.apply(subchain);
        exprNode.addChildNode(node);
        return new Pair<ExprNode, ExprTableAccessNode>(exprNode, node);
    }

    private static boolean isSingleParameterConstantOfType(List<ExprNode> expressions, Class expected) {
        if (expressions.size() != 1) {
            return false;
        }
        ExprNode first = expressions.get(0);
        return ChainableWalkHelper.isConstantExprOfType(first, expected);
    }

    private static boolean isConstantExprOfType(ExprNode node, Class expected) {
        if (!(node instanceof ExprConstantNode)) {
            return false;
        }
        ExprConstantNode constantNode = (ExprConstantNode)node;
        if (!constantNode.constantAvailable()) {
            return false;
        }
        EPType type = constantNode.getConstantType();
        if (type == null || type == EPTypeNull.INSTANCE) {
            return expected == null;
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        return JavaClassHelper.getBoxedType(typeClass).getType() == expected;
    }

    private static String toPlainPropertyString(List<Chainable> chain, int startIndex) throws ChainableWalkNotAPropertyException {
        StringWriter buffer = new StringWriter();
        String delimiter = "";
        for (Chainable element : chain.subList(startIndex, chain.size())) {
            if (element instanceof ChainableName) {
                ChainableName name = (ChainableName)element;
                buffer.append(delimiter);
                buffer.append(name.getNameUnescaped());
            } else if (element instanceof ChainableArray) {
                ChainableArray array = (ChainableArray)element;
                if (array.getIndexes().size() != 1) {
                    throw new ChainableWalkNotAPropertyException("Expected plain array property but found multiple index expressions");
                }
                buffer.append("[");
                buffer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(array.getIndexes().get(0)));
                buffer.append("]");
            } else if (element instanceof ChainableCall) {
                ChainableCall call = (ChainableCall)element;
                if (call.getParameters().size() != 1) {
                    throw new ChainableWalkNotAPropertyException("Expected plain mapped property but found multiple key expressions");
                }
                buffer.append(delimiter);
                buffer.append(call.getNameUnescaped());
                buffer.append("(");
                ExprNode param = call.getParameters().get(0);
                if (!(param instanceof ExprConstantNode)) {
                    throw new ChainableWalkNotAPropertyException("Expected plain mapped property single constant parameter");
                }
                ExprConstantNode constantNode = (ExprConstantNode)param;
                if (constantNode.getStringConstantWhenProvided() != null) {
                    buffer.append(constantNode.getStringConstantWhenProvided());
                } else {
                    buffer.append("'");
                    buffer.append((String)constantNode.getConstantValue());
                    buffer.append("'");
                }
                buffer.append(")");
            }
            if (element.isOptional()) {
                buffer.append("?");
            }
            delimiter = ".";
        }
        return buffer.toString();
    }
}

