/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprCoalesceNodeForge;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprCoalesceNode
extends ExprNodeBase {
    private transient ExprCoalesceNodeForge forge;

    public ExprEvaluator getExprEvaluator() {
        ExprCoalesceNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprCoalesceNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EPType resultType;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Coalesce node must have at least 2 parameters");
        }
        EPType[] childTypes = new EPType[this.getChildNodes().length];
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            childTypes[i] = this.getChildNodes()[i].getForge().getEvaluationType();
        }
        try {
            resultType = JavaClassHelper.getCommonCoercionType(childTypes);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        boolean[] isNumericCoercion = new boolean[this.getChildNodes().length];
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            ExprNode node = this.getChildNodes()[i];
            EPType type = node.getForge().getEvaluationType();
            EPType boxed = JavaClassHelper.getBoxedType(type);
            if (resultType == null || boxed == null || boxed == EPTypeNull.INSTANCE || boxed.equals(resultType)) continue;
            if (!JavaClassHelper.isNumeric(resultType)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + resultType.getTypeName() + "' to " + node.getForge().getEvaluationType() + " is not allowed");
            }
            isNumericCoercion[i] = true;
        }
        this.forge = new ExprCoalesceNodeForge(this, resultType, isNumericCoercion);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        ExprNodeUtilityPrint.toExpressionStringWFunctionName("coalesce", this.getChildNodes(), writer);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprCoalesceNode;
    }
}

