/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.funcs;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprDotStaticMethodWrapFactory;
import com.espertech.esper.common.internal.epl.expression.chain.Chainable;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeInnerNodeProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandlerDefault;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityResolve;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeWithChainSpec;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotForge;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeFilterAnalyzerInputStatic;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeForgeStaticMethod;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeUtility;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNodeForge;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNodeForgeConst;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNodeForgeNC;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeContextPropertiesVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeStreamRequiredVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ExprPlugInSingleRowNode
extends ExprNodeBase
implements ExprFilterOptimizableNode,
ExprNodeInnerNodeProvider,
ExprNodeWithChainSpec {
    private final String functionName;
    private final Class clazz;
    private final List<Chainable> chainSpec;
    private final ClasspathImportSingleRowDesc config;
    private ExprPlugInSingleRowNodeForge forge;
    private transient StatementCompileTimeServices compileTimeServices;
    private transient StatementRawInfo statementRawInfo;

    public ExprPlugInSingleRowNode(String functionName, Class clazz, List<Chainable> chainSpec, ClasspathImportSingleRowDesc config) {
        this.functionName = functionName;
        this.clazz = clazz;
        this.chainSpec = chainSpec;
        this.config = config;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprPlugInSingleRowNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprPlugInSingleRowNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public List<Chainable> getChainSpec() {
        return this.chainSpec;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean getFilterLookupEligible() {
        ExprNodeVisitor visitor;
        boolean eligible;
        boolean bl = eligible = !this.forge.isReturnsConstantResult() && this.forge.getEvaluationType() != null && this.forge.getEvaluationType() != EPTypeNull.INSTANCE;
        if (eligible) {
            boolean bl2 = eligible = this.chainSpec.size() == 1;
        }
        if (eligible) {
            boolean bl3 = eligible = this.config.getFilterOptimizable() == ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.ENABLED;
        }
        if (eligible) {
            visitor = new ExprNodeContextPropertiesVisitor();
            ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
            boolean bl4 = eligible = !((ExprNodeContextPropertiesVisitor)visitor).isFound();
        }
        if (eligible) {
            visitor = new ExprNodeStreamRequiredVisitor();
            ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
            for (int stream : ((ExprNodeStreamRequiredVisitor)visitor).getStreamsRequired()) {
                if (stream == 0) continue;
                eligible = false;
            }
        }
        if (eligible) {
            visitor = new ExprNodeSubselectDeclaredDotVisitor();
            ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
            if (!((ExprNodeSubselectDeclaredDotVisitor)visitor).getSubselects().isEmpty()) {
                eligible = false;
            }
        }
        if (eligible && this.forge.isHasMethodInvocationContextParam()) {
            eligible = false;
        }
        return eligible;
    }

    @Override
    public ExprFilterSpecLookupableForge getFilterLookupable() {
        ExprPlugInSingleRowNode.checkValidated(this.forge);
        DataInputOutputSerdeForge filterSerde = this.compileTimeServices.getSerdeResolver().serdeForFilter((EPTypeClass)this.forge.getEvaluationType(), this.statementRawInfo);
        return new ExprFilterSpecLookupableForge(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this), this.forge, null, (EPTypeClass)this.forge.getEvaluationType(), true, filterSerde);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        ExprNodeUtilityPrint.toExpressionString(this.chainSpec, writer, false, this.functionName);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprPlugInSingleRowNode)) {
            return false;
        }
        ExprPlugInSingleRowNode other = (ExprPlugInSingleRowNode)node;
        if (other.chainSpec.size() != this.chainSpec.size()) {
            return false;
        }
        for (int i = 0; i < this.chainSpec.size(); ++i) {
            if (this.chainSpec.get(i).equals(other.chainSpec.get(i))) continue;
            return false;
        }
        return other.clazz == this.clazz && other.functionName.endsWith(this.functionName);
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        boolean isReturnsConstantResult;
        this.compileTimeServices = validationContext.getStatementCompileTimeService();
        this.statementRawInfo = validationContext.getStatementRawInfo();
        ExprNodeUtilityValidate.validate(ExprNodeOrigin.PLUGINSINGLEROWPARAM, this.chainSpec, validationContext);
        ArrayList<Chainable> chainList = new ArrayList<Chainable>(this.chainSpec);
        Chainable firstItem = (Chainable)chainList.remove(0);
        boolean allowWildcard = validationContext.getStreamTypeService().getEventTypes().length == 1;
        EventType streamZeroType = null;
        if (validationContext.getStreamTypeService().getEventTypes().length > 0) {
            streamZeroType = validationContext.getStreamTypeService().getEventTypes()[0];
        }
        ExprNodeUtilMethodDesc staticMethodDesc = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(this.clazz.getName(), null, firstItem.getRootNameOrEmptyString(), firstItem.getParametersOrEmpty(), allowWildcard, streamZeroType, new ExprNodeUtilResolveExceptionHandlerDefault(firstItem.getRootNameOrEmptyString(), true), this.functionName, validationContext.getStatementRawInfo(), validationContext.getStatementCompileTimeService());
        boolean allowValueCache = true;
        if (this.config.getValueCache() == ConfigurationCompilerPlugInSingleRowFunction.ValueCache.DISABLED) {
            isReturnsConstantResult = false;
            allowValueCache = false;
        } else if (this.config.getValueCache() == ConfigurationCompilerPlugInSingleRowFunction.ValueCache.CONFIGURED) {
            boolean isUDFCache = validationContext.getStatementCompileTimeService().getConfiguration().getCompiler().getExpression().isUdfCache();
            isReturnsConstantResult = isUDFCache && staticMethodDesc.isAllConstants() && chainList.isEmpty();
            allowValueCache = isUDFCache;
        } else if (this.config.getValueCache() == ConfigurationCompilerPlugInSingleRowFunction.ValueCache.ENABLED) {
            isReturnsConstantResult = staticMethodDesc.isAllConstants() && chainList.isEmpty();
        } else {
            throw new IllegalStateException("Invalid value cache code " + (Object)((Object)this.config.getValueCache()));
        }
        ExprDotStaticMethodWrap optionalLambdaWrap = ExprDotStaticMethodWrapFactory.make(staticMethodDesc.getReflectionMethod(), chainList, this.config.getOptionalEventTypeName(), validationContext);
        EPTypeClass methodReturnClass = ClassHelperGenericType.getMethodReturnEPType(staticMethodDesc.getReflectionMethod());
        EPChainableType typeInfo = optionalLambdaWrap != null ? optionalLambdaWrap.getTypeInfo() : EPChainableTypeHelper.singleValue(methodReturnClass);
        ExprDotForge[] eval = ExprDotNodeUtility.getChainEvaluators(-1, typeInfo, chainList, validationContext, false, new ExprDotNodeFilterAnalyzerInputStatic()).getChainWithUnpack();
        ExprDotNodeForgeStaticMethod staticMethodForge = new ExprDotNodeForgeStaticMethod(this, isReturnsConstantResult, this.clazz.getName(), staticMethodDesc.getReflectionMethod(), staticMethodDesc.getChildForges(), allowValueCache && staticMethodDesc.isAllConstants(), eval, optionalLambdaWrap, this.config.isRethrowExceptions(), null, validationContext.getStatementName(), staticMethodDesc.isLocalInlinedClass());
        this.forge = isReturnsConstantResult ? new ExprPlugInSingleRowNodeForgeConst(this, staticMethodForge) : new ExprPlugInSingleRowNodeForgeNC(this, staticMethodForge);
        return null;
    }

    @Override
    public void accept(ExprNodeVisitor visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec);
    }

    @Override
    public void accept(ExprNodeVisitorWithParent visitor) {
        super.accept(visitor);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void acceptChildnodes(ExprNodeVisitorWithParent visitor, ExprNode parent) {
        super.acceptChildnodes(visitor, parent);
        ExprNodeUtilityQuery.acceptChain(visitor, this.chainSpec, this);
    }

    @Override
    public void replaceUnlistedChildNode(ExprNode nodeToReplace, ExprNode newNode) {
        ExprNodeUtilityModify.replaceChainChildNode(nodeToReplace, newNode, this.chainSpec);
    }

    @Override
    public List<ExprNode> getAdditionalNodes() {
        return ExprNodeUtilityQuery.collectChainParameters(this.chainSpec);
    }

    public ClasspathImportSingleRowDesc getConfig() {
        return this.config;
    }

    public boolean isLocalInlinedClass() {
        return this.forge.isLocalInlinedClass();
    }
}

