/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNodeImpl;

public class ExprAndNodeEval
implements ExprEvaluator {
    private final ExprAndNodeImpl parent;
    private final ExprEvaluator[] evaluators;

    public ExprAndNodeEval(ExprAndNodeImpl parent, ExprEvaluator[] evaluators) {
        this.parent = parent;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = true;
        for (ExprEvaluator child : this.evaluators) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (evaluated == null) {
                result = null;
                continue;
            }
            if (evaluated.booleanValue()) continue;
            return false;
        }
        return result;
    }

    public static CodegenExpression codegen(ExprAndNodeImpl parent, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprAndNodeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "result", CodegenExpressionBuilder.constantTrue());
        int count = -1;
        for (ExprNode child : parent.getChildNodes()) {
            ++count;
            EPTypeClass childType = (EPTypeClass)child.getForge().getEvaluationType();
            if (childType.getType().isPrimitive()) {
                block.ifCondition(CodegenExpressionBuilder.not(child.getForge().evaluateCodegen(EPTypePremade.BOOLEANBOXED.getEPType(), methodNode, exprSymbol, codegenClassScope))).blockReturn(CodegenExpressionBuilder.constantFalse());
                continue;
            }
            String refname = "r" + count;
            block.declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), refname, child.getForge().evaluateCodegen(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(refname))).assignRef("result", CodegenExpressionBuilder.constantNull()).ifElse().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref(refname))).blockReturn(CodegenExpressionBuilder.constantFalse());
        }
        block.methodReturn(CodegenExpressionBuilder.ref("result"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

