/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNodeForge;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.LinkedList;

public class ExprArrayNode
extends ExprNodeBase {
    private transient ExprArrayNodeForge forge;
    private EPTypeClass optionalRequiredType;

    public ExprEvaluator getExprEvaluator() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    public boolean isConstantResult() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getConstantResult() != null;
    }

    @Override
    public ExprForge getForge() {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge;
    }

    public EPTypeClass getComponentTypeCollection() throws ExprValidationException {
        ExprArrayNode.checkValidated(this.forge);
        return this.forge.getArrayReturnType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        void var9_19;
        int length = this.getChildNodes().length;
        if (this.getChildNodes().length == 0) {
            this.forge = this.optionalRequiredType == null ? new ExprArrayNodeForge(this, EPTypePremade.OBJECT.getEPType(), CollectionUtil.OBJECTARRAY_EMPTY) : new ExprArrayNodeForge(this, this.optionalRequiredType, Array.newInstance(this.optionalRequiredType.getType(), 0));
            return null;
        }
        LinkedList<EPType> comparedTypes = new LinkedList<EPType>();
        for (int i = 0; i < length; ++i) {
            EPType evalType = this.getChildNodes()[i].getForge().getEvaluationType();
            comparedTypes.add(evalType);
        }
        EPTypeClass arrayReturnType = null;
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        try {
            if (this.optionalRequiredType == null) {
                EPType coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new EPType[comparedTypes.size()]));
                EPTypeClass ePTypeClass = arrayReturnType = coercionType == null || coercionType == EPTypeNull.INSTANCE ? null : (EPTypeClass)coercionType;
                if (JavaClassHelper.isNumeric(arrayReturnType)) {
                    for (EPType ePType : comparedTypes) {
                        if (ePType.equals(arrayReturnType)) continue;
                        mustCoerce = true;
                        break;
                    }
                    if (mustCoerce) {
                        coercer = SimpleNumberCoercerFactory.getCoercer(null, arrayReturnType);
                    }
                }
            } else {
                arrayReturnType = this.optionalRequiredType;
                EPTypeClass arrayBoxedType = JavaClassHelper.getBoxedType(this.optionalRequiredType);
                for (EPType ePType : comparedTypes) {
                    if (JavaClassHelper.isAssignmentCompatible(JavaClassHelper.getBoxedType(ePType), arrayBoxedType.getType())) continue;
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + ClassHelperPrint.getClassNameFullyQualPretty(arrayReturnType) + " but received type " + ClassHelperPrint.getClassNameFullyQualPretty(ePType));
                }
            }
        }
        catch (CoercionException arrayBoxedType) {
            // empty catch block
        }
        if (arrayReturnType == null) {
            arrayReturnType = EPTypePremade.OBJECT.getEPType();
        }
        Object[] results = new Object[length];
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (!child.getForge().getForgeConstantType().isCompileTimeConstant()) {
                results = null;
                break;
            }
            results[index] = this.getChildNodes()[index].getForge().getExprEvaluator().evaluate(null, false, null);
            ++index;
        }
        Object var9_17 = null;
        if (results != null) {
            Object object = Array.newInstance(arrayReturnType.getType(), length);
            for (int i = 0; i < length; ++i) {
                if (mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = coercer.coerceBoxed(boxed);
                    Array.set(object, i, coercedResult);
                    continue;
                }
                if (arrayReturnType.getType().isPrimitive() && results[i] == null) {
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + ClassHelperPrint.getClassNameFullyQualPretty(arrayReturnType) + " but received null");
                }
                try {
                    Array.set(object, i, results[i]);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new ExprValidationException("Array element type mismatch: Expecting type " + ClassHelperPrint.getClassNameFullyQualPretty(arrayReturnType) + " but received type " + ClassHelperPrint.getClassNameFullyQualPretty(results[i].getClass()));
                }
            }
        }
        this.forge = new ExprArrayNodeForge(this, arrayReturnType, mustCoerce, coercer, var9_19);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String delimiter = "";
        writer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
            delimiter = ",";
        }
        writer.append('}');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprArrayNode;
    }

    public void setOptionalRequiredType(EPTypeClass optionalRequiredType) {
        this.optionalRequiredType = optionalRequiredType;
    }

    public EPTypeClass getOptionalRequiredType() {
        return this.optionalRequiredType;
    }
}

