/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNodeForge;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;

public class ExprArrayNodeForgeEval
implements ExprEvaluator,
ExprEnumerationEval {
    private static final String PRIMITIVE_ARRAY_NULL_MSG = "new-array received a null value as an array element of an array of primitives";
    private final ExprArrayNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprArrayNodeForgeEval(ExprArrayNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    public ExprEnumerationEval getExprEvaluatorEnumeration() {
        return this;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object array = Array.newInstance(this.forge.getArrayReturnType().getType(), this.evaluators.length);
        int index = 0;
        boolean requiresPrimitive = this.forge.getParent().getOptionalRequiredType() != null && this.forge.getParent().getOptionalRequiredType().getType().isPrimitive();
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result != null) {
                if (this.forge.isMustCoerce()) {
                    Number boxed = (Number)result;
                    Number coercedResult = this.forge.getCoercer().coerceBoxed(boxed);
                    Array.set(array, index, coercedResult);
                } else {
                    Array.set(array, index, result);
                }
            } else if (requiresPrimitive) {
                throw new EPException(PRIMITIVE_ARRAY_NULL_MSG);
            }
            ++index;
        }
        return array;
    }

    public static CodegenExpression codegen(ExprArrayNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(forge.getEvaluationType(), ExprArrayNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(forge.getEvaluationType(), "array", CodegenExpressionBuilder.newArrayByLength(forge.getArrayReturnType(), CodegenExpressionBuilder.constant(forge.getForgeRenderable().getChildNodes().length)));
        boolean requiresPrimitive = forge.getParent().getOptionalRequiredType() != null && forge.getParent().getOptionalRequiredType().getType().isPrimitive();
        for (int i = 0; i < forge.getForgeRenderable().getChildNodes().length; ++i) {
            ExprForge child = forge.getForgeRenderable().getChildNodes()[i].getForge();
            EPType childType = child.getEvaluationType();
            if (childType == null || childType == EPTypeNull.INSTANCE) continue;
            EPTypeClass childTypeClass = (EPTypeClass)childType;
            String refname = "r" + i;
            block.declareVar(childTypeClass, refname, child.evaluateCodegen(childTypeClass, methodNode, exprSymbol, codegenClassScope));
            if (childTypeClass.getType().isPrimitive()) {
                if (!forge.isMustCoerce()) {
                    block.assignArrayElement("array", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(refname));
                    continue;
                }
                block.assignArrayElement("array", CodegenExpressionBuilder.constant(i), forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), childTypeClass));
                continue;
            }
            CodegenBlock ifNotNull = block.ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname)));
            if (!forge.isMustCoerce()) {
                ifNotNull.assignArrayElement("array", CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(refname));
            } else {
                ifNotNull.assignArrayElement("array", CodegenExpressionBuilder.constant(i), forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), childTypeClass));
            }
            if (!requiresPrimitive) continue;
            block.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(refname))).blockThrow(CodegenExpressionBuilder.newInstance(EPException.EPTYPE, CodegenExpressionBuilder.constant(PRIMITIVE_ARRAY_NULL_MSG)));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("array"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.forge.getForgeRenderable().getChildNodes().length == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> resultList = new ArrayDeque<Object>(this.evaluators.length);
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, context);
            if (result == null) continue;
            if (this.forge.isMustCoerce()) {
                Number boxed = (Number)result;
                Number coercedResult = this.forge.getCoercer().coerceBoxed(boxed);
                resultList.add(coercedResult);
                continue;
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static CodegenExpression codegenEvaluateGetROCollectionScalar(ExprArrayNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprNode[] children = forge.getForgeRenderable().getChildNodes();
        if (children.length == 0) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyList", new CodegenExpression[0]);
        }
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.COLLECTION.getEPType(), ExprArrayNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "resultList", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.constant(children.length)));
        int count = -1;
        for (ExprNode child : children) {
            String refname = "r" + ++count;
            ExprForge childForge = child.getForge();
            EPType returnType = childForge.getEvaluationType();
            if (returnType == null || returnType == EPTypeNull.INSTANCE) continue;
            EPTypeClass returnClass = (EPTypeClass)returnType;
            block.declareVar(returnClass, refname, childForge.evaluateCodegen((EPTypeClass)returnType, methodNode, exprSymbol, codegenClassScope));
            CodegenExpression nonNullTest = returnClass.getType().isPrimitive() ? CodegenExpressionBuilder.constantTrue() : CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref(refname));
            CodegenBlock blockIfNotNull = block.ifCondition(nonNullTest);
            CodegenExpression added = CodegenExpressionBuilder.ref(refname);
            if (forge.isMustCoerce()) {
                added = forge.getCoercer().coerceCodegen(CodegenExpressionBuilder.ref(refname), (EPTypeClass)childForge.getEvaluationType());
            }
            blockIfNotNull.expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("resultList"), "add", added));
        }
        block.methodReturn(CodegenExpressionBuilder.ref("resultList"));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }
}

