/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.ThreadingProfile;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprConcatNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprConcatNode
extends ExprNodeBase {
    private transient ExprConcatNodeForge forge;

    public ExprEvaluator getExprEvaluator() {
        ExprConcatNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprConcatNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("Concat node must have at least 2 parameters");
        }
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            EPType childType = this.getChildNodes()[i].getForge().getEvaluationType();
            if (JavaClassHelper.isTypeString(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + (childType == null ? "null" : childType.getTypeName()) + "' to string is not allowed");
        }
        ThreadingProfile threadingProfile = validationContext.getStatementCompileTimeService().getConfiguration().getCommon().getExecution().getThreadingProfile();
        this.forge = new ExprConcatNodeForge(this, threadingProfile);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String delimiter = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(delimiter);
            child.toEPL(writer, this.getPrecedence(), flags);
            delimiter = "||";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.CONCAT;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprConcatNode;
    }
}

