/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsAllAnyNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class ExprEqualsAllAnyNodeForgeEvalAnyWColl
implements ExprEvaluator {
    private final ExprEqualsAllAnyNodeForge forge;
    private final ExprEvaluator[] evaluators;

    public ExprEqualsAllAnyNodeForgeEvalAnyWColl(ExprEqualsAllAnyNodeForge forge, ExprEvaluator[] evaluators) {
        this.forge = forge;
        this.evaluators = evaluators;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Object evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object leftResult = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (this.forge.isMustCoerce() && leftResult != null) {
            leftResult = this.forge.getCoercer().coerceBoxed((Number)leftResult);
        }
        return this.compareAny(leftResult, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private Object compareAny(Object leftResult, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        boolean isNot = this.forge.getForgeRenderable().isNot();
        int len = this.forge.getForgeRenderable().getChildNodes().length - 1;
        boolean hasNonNullRow = false;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Object rightResult = this.evaluators[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) {
                hasNullRow = true;
                continue;
            }
            if (rightResult instanceof Collection) {
                if (leftResult == null) {
                    return null;
                }
                Collection coll = (Collection)rightResult;
                if (!isNot && coll.contains(leftResult) || isNot && !coll.contains(leftResult)) {
                    return true;
                }
                hasNonNullRow = true;
                continue;
            }
            if (rightResult instanceof Map) {
                if (leftResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (!isNot && coll.containsKey(leftResult) || isNot && !coll.containsKey(leftResult)) {
                    return true;
                }
                hasNonNullRow = true;
                continue;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                if (arrayLength > 0 && leftResult == null) {
                    return null;
                }
                for (int index = 0; index < arrayLength; ++index) {
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    hasNonNullRow = true;
                    if (!this.forge.isMustCoerce()) {
                        if ((isNot || !leftResult.equals(item)) && (!isNot || leftResult.equals(item))) continue;
                        return true;
                    }
                    if (!(item instanceof Number)) continue;
                    Number left = this.forge.getCoercer().coerceBoxed((Number)leftResult);
                    Number right = this.forge.getCoercer().coerceBoxed((Number)item);
                    if ((isNot || !left.equals(right)) && (!isNot || left.equals(right))) continue;
                    return true;
                }
                continue;
            }
            if (leftResult == null) {
                return null;
            }
            hasNonNullRow = true;
            if (!this.forge.isMustCoerce()) {
                if ((isNot || !leftResult.equals(rightResult)) && (!isNot || leftResult.equals(rightResult))) continue;
                return true;
            }
            Number left = this.forge.getCoercer().coerceBoxed((Number)leftResult);
            Number right = this.forge.getCoercer().coerceBoxed((Number)rightResult);
            if ((isNot || !left.equals(right)) && (!isNot || left.equals(right))) continue;
            return true;
        }
        if (!hasNonNullRow || hasNullRow) {
            return null;
        }
        return false;
    }

    public static CodegenExpression codegen(ExprEqualsAllAnyNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge[] forges = ExprNodeUtilityQuery.getForges(forge.getForgeRenderable().getChildNodes());
        boolean isNot = forge.getForgeRenderable().isNot();
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprEqualsAllAnyNodeForgeEvalAnyWColl.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock();
        EPTypeClass leftTypeUncoerced = (EPTypeClass)forges[0].getEvaluationType();
        block.declareVar(leftTypeUncoerced, "left", forges[0].evaluateCodegen(leftTypeUncoerced, methodNode, exprSymbol, codegenClassScope));
        block.declareVar(forge.getCoercionTypeBoxed(), "leftCoerced", !forge.isMustCoerce() ? CodegenExpressionBuilder.ref("left") : forge.getCoercer().coerceCodegenMayNullBoxed(CodegenExpressionBuilder.ref("left"), leftTypeUncoerced, methodNode, codegenClassScope));
        block.declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "hasNonNullRow", CodegenExpressionBuilder.constantFalse());
        block.declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "hasNullRow", CodegenExpressionBuilder.constantFalse());
        for (int i = 1; i < forges.length; ++i) {
            Class<?> refClass;
            ExprForge refforge = forges[i];
            String refname = "r" + i;
            EPType refType = forges[i].getEvaluationType();
            Class<?> clazz = refClass = refType == null || refType == EPTypeNull.INSTANCE ? null : ((EPTypeClass)refType).getType();
            if (refClass != null && JavaClassHelper.isImplementsInterface(refClass, Collection.class)) {
                block.ifRefNullReturnNull("left").declareVar(EPTypePremade.COLLECTION.getEPType(), refname, refforge.evaluateCodegen(EPTypePremade.COLLECTION.getEPType(), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(refname))).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue()).ifElse().assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue()).ifCondition(CodegenExpressionBuilder.notOptional(isNot, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refname), "contains", CodegenExpressionBuilder.ref("left")))).blockReturn(CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (refClass != null && JavaClassHelper.isImplementsInterface(refClass, Map.class)) {
                block.ifRefNullReturnNull("left").declareVar(EPTypePremade.MAP.getEPType(), refname, refforge.evaluateCodegen(EPTypePremade.MAP.getEPType(), methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(refname))).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue()).ifElse().assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue()).ifCondition(CodegenExpressionBuilder.notOptional(isNot, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(refname), "containsKey", CodegenExpressionBuilder.ref("left")))).blockReturn(CodegenExpressionBuilder.constantTrue());
                continue;
            }
            if (refClass != null && refClass.isArray()) {
                EPTypeClass refClassType = (EPTypeClass)refType;
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType(refClassType);
                CodegenBlock arrayBlock = block.ifRefNullReturnNull("left").declareVar(refClassType, refname, refforge.evaluateCodegen((EPTypeClass)refType, methodNode, exprSymbol, codegenClassScope)).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref(refname))).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue()).ifElse();
                CodegenBlock forLoop = arrayBlock.forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref(refname)));
                CodegenExpression arrayAtIndex = CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref(refname), CodegenExpressionBuilder.ref("i"));
                forLoop.declareVar(forge.getCoercionTypeBoxed(), "item", forge.getCoercer() == null ? arrayAtIndex : forge.getCoercer().coerceCodegenMayNullBoxed(arrayAtIndex, componentType, methodNode, codegenClassScope));
                CodegenBlock forLoopElse = forLoop.ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("item"))).assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue()).ifElse();
                forLoopElse.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
                forLoopElse.ifCondition(CodegenExpressionBuilder.notOptional(isNot, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("leftCoerced"), "equals", CodegenExpressionBuilder.ref("item")))).blockReturn(CodegenExpressionBuilder.constantTrue());
                continue;
            }
            block.ifRefNullReturnNull("leftCoerced");
            CodegenExpression rhs = CodegenExpressionBuilder.constantNull();
            if (refClass != null) {
                rhs = forge.getCoercer() == null ? refforge.evaluateCodegen(forge.getCoercionTypeBoxed(), methodNode, exprSymbol, codegenClassScope) : forge.getCoercer().coerceCodegenMayNullBoxed(refforge.evaluateCodegen(forge.getCoercionTypeBoxed(), methodNode, exprSymbol, codegenClassScope), refType, methodNode, codegenClassScope);
            }
            block.declareVar(forge.getCoercionTypeBoxed(), refname, rhs);
            CodegenBlock ifRightNotNull = block.ifRefNotNull(refname);
            ifRightNotNull.assignRef("hasNonNullRow", CodegenExpressionBuilder.constantTrue());
            ifRightNotNull.ifCondition(CodegenExpressionBuilder.notOptional(isNot, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("leftCoerced"), "equals", CodegenExpressionBuilder.ref(refname)))).blockReturn(CodegenExpressionBuilder.constantTrue());
            ifRightNotNull.ifElse().assignRef("hasNullRow", CodegenExpressionBuilder.constantTrue());
        }
        block.ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.not(CodegenExpressionBuilder.ref("hasNonNullRow")), CodegenExpressionBuilder.ref("hasNullRow"), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull());
        block.methodReturn(CodegenExpressionBuilder.constantFalse());
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

