/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeForgeCoercion;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNodeImpl;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;

public class ExprEqualsNodeForgeCoercionEval
implements ExprEvaluator {
    private final ExprEqualsNodeImpl parent;
    private final ExprEvaluator lhs;
    private final ExprEvaluator rhs;
    private final SimpleNumberCoercer numberCoercerLHS;
    private final SimpleNumberCoercer numberCoercerRHS;

    public ExprEqualsNodeForgeCoercionEval(ExprEqualsNodeImpl parent, ExprEvaluator lhs, ExprEvaluator rhs, SimpleNumberCoercer numberCoercerLHS, SimpleNumberCoercer numberCoercerRHS) {
        this.parent = parent;
        this.lhs = lhs;
        this.rhs = rhs;
        this.numberCoercerLHS = numberCoercerLHS;
        this.numberCoercerRHS = numberCoercerRHS;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.evaluateInternal(eventsPerStream, isNewData, context);
    }

    private Boolean evaluateInternal(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object leftResult = this.lhs.evaluate(eventsPerStream, isNewData, context);
        Object rightResult = this.rhs.evaluate(eventsPerStream, isNewData, context);
        if (!this.parent.isIs()) {
            if (leftResult == null || rightResult == null) {
                return null;
            }
        } else {
            if (leftResult == null) {
                return rightResult == null;
            }
            if (rightResult == null) {
                return false;
            }
        }
        Number left = this.numberCoercerLHS.coerceBoxed((Number)leftResult);
        Number right = this.numberCoercerRHS.coerceBoxed((Number)rightResult);
        return left.equals(right) ^ this.parent.isNotEquals();
    }

    public static CodegenMethod codegen(ExprEqualsNodeForgeCoercion forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope, ExprNode lhs, ExprNode rhs) {
        EPTypeClass lhsType = forge.getLhsTypeClass();
        EPTypeClass rhsType = forge.getRhsTypeClass();
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprEqualsNodeForgeCoercionEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(lhsType, "l", lhs.getForge().evaluateCodegen(lhsType, methodNode, exprSymbol, codegenClassScope)).declareVar(rhsType, "r", rhs.getForge().evaluateCodegen(rhsType, methodNode, exprSymbol, codegenClassScope));
        if (!forge.getForgeRenderable().isIs()) {
            if (!lhsType.getType().isPrimitive()) {
                block.ifRefNullReturnNull("l");
            }
            if (!rhsType.getType().isPrimitive()) {
                block.ifRefNullReturnNull("r");
            }
        } else {
            if (!lhsType.getType().isPrimitive() && !rhsType.getType().isPrimitive()) {
                block.ifRefNull("l").blockReturn(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("r")));
            }
            if (!rhsType.getType().isPrimitive()) {
                block.ifRefNull("r").blockReturn(CodegenExpressionBuilder.constantFalse());
            }
        }
        block.declareVar(EPTypePremade.NUMBER.getEPType(), "left", forge.getNumberCoercerLHS().coerceCodegen(CodegenExpressionBuilder.ref("l"), lhsType));
        block.declareVar(EPTypePremade.NUMBER.getEPType(), "right", forge.getNumberCoercerRHS().coerceCodegen(CodegenExpressionBuilder.ref("r"), rhsType));
        CodegenExpression compare = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("left"), "equals", CodegenExpressionBuilder.ref("right"));
        if (!forge.getForgeRenderable().isNotEquals()) {
            block.methodReturn(compare);
        } else {
            block.methodReturn(CodegenExpressionBuilder.not(compare));
        }
        return methodNode;
    }
}

