/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeForge;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ExprInNodeImpl
extends ExprNodeBase
implements ExprInNode {
    private final boolean isNotIn;
    private transient ExprInNodeForge forge;

    public ExprInNodeImpl(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprInNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    @Override
    public boolean isNotIn() {
        return this.isNotIn;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.validateWithoutContext();
        return null;
    }

    @Override
    public void validateWithoutContext() throws ExprValidationException {
        EPType coercionType;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("The IN operator requires at least 2 child expressions");
        }
        EPType typeRoot = this.getChildNodes()[0].getForge().getEvaluationType();
        EPType typeRootBoxed = JavaClassHelper.getBoxedType(typeRoot);
        EPTypeClass typeRootClass = ExprNodeUtilityValidate.validateLHSTypeAnyAllSomeIn(typeRootBoxed);
        ArrayList<EPType> comparedTypes = new ArrayList<EPType>();
        comparedTypes.add(typeRootClass);
        boolean hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            EPType childType = this.getChildNodes()[i + 1].getForge().getEvaluationType();
            if (childType == null || childType == EPTypeNull.INSTANCE) continue;
            EPTypeClass childClass = (EPTypeClass)childType;
            if (childClass.getType().isArray()) {
                hasCollectionOrArray = true;
                if (childClass.getType().getComponentType() == Object.class) continue;
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType(childClass);
                comparedTypes.add(componentType);
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(childClass, Collection.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(childClass, Map.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(childType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new EPType[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        if (coercionType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Implicit conversion from null-type is not allowed");
        }
        EPTypeClass coercionClass = (EPTypeClass)coercionType;
        boolean mustCoerce = false;
        SimpleNumberCoercer coercer = null;
        if (JavaClassHelper.isNumeric(coercionClass)) {
            for (EPType compareType : comparedTypes) {
                if (coercionType.equals(JavaClassHelper.getBoxedType(compareType))) continue;
                mustCoerce = true;
            }
            if (mustCoerce) {
                coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionClass));
            }
        }
        this.forge = new ExprInNodeForge(this, mustCoerce, coercer, coercionClass, hasCollectionOrArray);
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprInNodeImpl)) {
            return false;
        }
        ExprInNodeImpl other = (ExprInNodeImpl)node;
        return other.isNotIn == this.isNotIn;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        String delimiter = "";
        Iterator<ExprNode> it = Arrays.asList(this.getChildNodes()).iterator();
        it.next().toEPL(writer, this.getPrecedence(), flags);
        if (this.isNotIn) {
            writer.append(" not in (");
        } else {
            writer.append(" in (");
        }
        do {
            ExprNode inSetValueExpr = it.next();
            writer.append(delimiter);
            inSetValueExpr.toEPL(writer, this.getPrecedence(), flags);
            delimiter = ",";
        } while (it.hasNext());
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }
}

