/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprMathNodeForge;
import com.espertech.esper.common.internal.type.MathArithTypeEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.math.BigDecimal;

public class ExprMathNode
extends ExprNodeBase {
    private final MathArithTypeEnum mathArithTypeEnum;
    private final boolean isIntegerDivision;
    private final boolean isDivisionByZeroReturnsNull;
    private transient ExprMathNodeForge forge;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        this.mathArithTypeEnum = mathArithTypeEnum;
        this.isIntegerDivision = isIntegerDivision;
        this.isDivisionByZeroReturnsNull = isDivisionByZeroReturnsNull;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprMathNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprMathNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 parameters");
        }
        for (ExprNode child : this.getChildNodes()) {
            ExprNodeUtilityValidate.validateReturnsNumeric(child.getForge());
        }
        ExprNode lhs = this.getChildNodes()[0];
        ExprNode rhs = this.getChildNodes()[1];
        EPTypeClass lhsType = (EPTypeClass)lhs.getForge().getEvaluationType();
        EPTypeClass rhsType = (EPTypeClass)rhs.getForge().getEvaluationType();
        EPTypeClass resultType = !(lhsType.getType() != Short.TYPE && lhsType.getType() != Short.class || rhsType.getType() != Short.TYPE && rhsType.getType() != Short.class) ? EPTypePremade.INTEGERBOXED.getEPType() : (!(lhsType.getType() != Byte.TYPE && lhsType.getType() != Byte.class || rhsType.getType() != Byte.TYPE && rhsType.getType() != Byte.class) ? EPTypePremade.INTEGERBOXED.getEPType() : (lhsType.equals(rhsType) ? JavaClassHelper.getBoxedType(rhsType) : JavaClassHelper.getArithmaticCoercionType(lhsType, rhsType)));
        if (this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE && !this.isIntegerDivision && resultType.getType() != BigDecimal.class) {
            resultType = EPTypePremade.DOUBLEBOXED.getEPType();
        }
        MathArithTypeEnum.Computer arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(resultType, lhsType, rhsType, this.isIntegerDivision, this.isDivisionByZeroReturnsNull, validationContext.getClasspathImportService().getDefaultMathContext());
        this.forge = new ExprMathNodeForge(this, arithTypeEnumComputer, resultType);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        writer.append(this.mathArithTypeEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        if (this.mathArithTypeEnum == MathArithTypeEnum.MULTIPLY || this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE || this.mathArithTypeEnum == MathArithTypeEnum.MODULO) {
            return ExprPrecedenceEnum.MULTIPLY;
        }
        return ExprPrecedenceEnum.ADDITIVE;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

