/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprArrayNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeArrayForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewInstanceNodeNonArrayForge;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactory;
import com.espertech.esper.common.internal.event.bean.manufacturer.InstanceManufacturerFactoryFactory;
import com.espertech.esper.common.internal.settings.ClasspathImportEPTypeUtil;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprNewInstanceNode
extends ExprNodeBase {
    private final ClassDescriptor classIdentNoDimensions;
    private final int numArrayDimensions;
    private boolean arrayInitializedByExpr;
    private transient ExprForge forge;

    public ExprNewInstanceNode(ClassDescriptor classIdentNoDimensions, int numArrayDimensions) {
        this.classIdentNoDimensions = classIdentNoDimensions;
        this.numArrayDimensions = numArrayDimensions;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprNewInstanceNode.checkValidated(this.forge);
        return this.forge;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class<?> primitive;
        EPTypeClass targetClass = null;
        if (this.numArrayDimensions > 0 && this.classIdentNoDimensions.getTypeParameters().isEmpty() && (primitive = JavaClassHelper.getPrimitiveClassForName(this.classIdentNoDimensions.getClassIdentifier())) != null) {
            targetClass = EPTypePremade.getOrCreate(primitive);
        }
        if (targetClass == null) {
            targetClass = ClasspathImportEPTypeUtil.resolveClassIdentifierToEPType(this.classIdentNoDimensions, false, validationContext.getClasspathImportService(), validationContext.getClassProvidedClasspathExtension());
        }
        if (targetClass == null) {
            throw new ExprValidationException("Failed to resolve type parameter '" + this.classIdentNoDimensions.toEPL() + "'");
        }
        if (this.numArrayDimensions == 0) {
            InstanceManufacturerFactory manufacturerFactory = InstanceManufacturerFactoryFactory.getManufacturer(targetClass, validationContext.getClasspathImportService(), this.getChildNodes());
            this.forge = new ExprNewInstanceNodeNonArrayForge(this, targetClass, manufacturerFactory);
            return null;
        }
        EPTypeClass targetClassArray = JavaClassHelper.getArrayType(targetClass, this.numArrayDimensions);
        if (this.getChildNodes().length == 1 && this.getChildNodes()[0] instanceof ExprArrayNode) {
            this.arrayInitializedByExpr = true;
        } else {
            for (ExprNode child : this.getChildNodes()) {
                EPType evalType = child.getForge().getEvaluationType();
                if (JavaClassHelper.isTypeInteger(evalType)) continue;
                String message = "New-keyword with an array-type result requires an Integer-typed dimension but received type '" + (evalType == null ? "null" : evalType.getTypeName()) + "'";
                throw new ExprValidationException(message);
            }
        }
        if (!this.arrayInitializedByExpr) {
            this.forge = new ExprNewInstanceNodeArrayForge(this, targetClass, targetClassArray);
            return null;
        }
        if (this.numArrayDimensions < 1 || this.numArrayDimensions > 2) {
            throw new IllegalStateException("Num-array-dimensions unexpected at " + this.numArrayDimensions);
        }
        ExprArrayNode arrayNode = (ExprArrayNode)this.getChildNodes()[0];
        if (this.numArrayDimensions == 2) {
            for (ExprNode inner : arrayNode.getChildNodes()) {
                if (!(inner instanceof ExprArrayNode)) {
                    throw new ExprValidationException("Two-dimensional array element does not allow element expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(inner) + "'");
                }
                ExprArrayNode innerArray = (ExprArrayNode)inner;
                innerArray.setOptionalRequiredType(targetClass);
                innerArray.validate(validationContext);
            }
            EPTypeClass component = JavaClassHelper.getArrayComponentType(targetClassArray);
            arrayNode.setOptionalRequiredType(component);
        } else {
            arrayNode.setOptionalRequiredType(targetClass);
        }
        arrayNode.validate(validationContext);
        this.forge = new ExprNewInstanceNodeArrayForge(this, targetClass, targetClassArray);
        return null;
    }

    public boolean isConstantResult() {
        return false;
    }

    public ClassDescriptor getClassIdentNoDimensions() {
        return this.classIdentNoDimensions;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprNewInstanceNode)) {
            return false;
        }
        ExprNewInstanceNode other = (ExprNewInstanceNode)node;
        return other.classIdentNoDimensions.equals(this.classIdentNoDimensions) && other.numArrayDimensions == this.numArrayDimensions;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.write("new ");
        writer.write(this.classIdentNoDimensions.toEPL());
        if (this.numArrayDimensions == 0) {
            ExprNodeUtilityPrint.toExpressionStringParams(writer, this.getChildNodes());
        } else if (this.arrayInitializedByExpr) {
            writer.write("[] ");
            this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.UNARY, flags);
        } else {
            for (ExprNode child : this.getChildNodes()) {
                writer.write("[");
                child.toEPL(writer, ExprPrecedenceEnum.UNARY, flags);
                writer.write("]");
            }
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    public int getNumArrayDimensions() {
        return this.numArrayDimensions;
    }

    public boolean isArrayInitializedByExpr() {
        return this.arrayInitializedByExpr;
    }
}

