/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprTypableReturnForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprNewStructNodeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExprNewStructNode
extends ExprNodeBase {
    private final String[] columnNames;
    private ExprNewStructNodeForge forge;

    public ExprNewStructNode(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprNewStructNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprNewStructNode.checkValidated(this.forge);
        return this.forge;
    }

    public Class getEvaluationType() {
        return Map.class;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        LinkedHashMap<String, Serializable> eventType = new LinkedHashMap<String, Serializable>();
        boolean isAllConstants = false;
        for (int i = 0; i < this.columnNames.length; ++i) {
            boolean bl = isAllConstants = isAllConstants && this.getChildNodes()[i].getForge().getForgeConstantType().isCompileTimeConstant();
            if (eventType.containsKey(this.columnNames[i])) {
                throw new ExprValidationException("Failed to validate new-keyword property names, property '" + this.columnNames[i] + "' has already been declared");
            }
            LinkedHashMap<String, Object> eventTypeResult = null;
            if (this.getChildNodes()[i].getForge() instanceof ExprTypableReturnForge) {
                eventTypeResult = ((ExprTypableReturnForge)this.getChildNodes()[i].getForge()).getRowProperties();
            }
            if (eventTypeResult != null) {
                eventType.put(this.columnNames[i], eventTypeResult);
                continue;
            }
            EPType type = this.getChildNodes()[i].getForge().getEvaluationType();
            EPType typeResult = type == null ? EPTypeNull.INSTANCE : JavaClassHelper.getBoxedType(type);
            eventType.put(this.columnNames[i], typeResult);
        }
        this.forge = new ExprNewStructNodeForge(this, isAllConstants, eventType);
        return null;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean isConstantResult() {
        ExprNewStructNode.checkValidated(this.forge);
        return this.forge.isAllConstants();
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprNewStructNode)) {
            return false;
        }
        ExprNewStructNode other = (ExprNewStructNode)node;
        return Arrays.deepEquals(other.columnNames, this.columnNames);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.write("new{");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length; ++i) {
            ExprIdentNode prop;
            writer.append(delimiter);
            writer.append(this.columnNames[i]);
            ExprNode expr = this.getChildNodes()[i];
            boolean outputexpr = true;
            if (expr instanceof ExprIdentNode && (prop = (ExprIdentNode)expr).getResolvedPropertyName().equals(this.columnNames[i])) {
                outputexpr = false;
            }
            if (outputexpr) {
                writer.append("=");
                expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
            }
            delimiter = ",";
        }
        writer.write("}");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }
}

