/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpAllAnyNodeForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExprRelationalOpAllAnyNode
extends ExprNodeBase {
    private final RelationalOpEnum relationalOpEnum;
    private final boolean isAll;
    private transient ExprRelationalOpAllAnyNodeForge forge;

    public ExprRelationalOpAllAnyNode(RelationalOpEnum relationalOpEnum, boolean isAll) {
        this.relationalOpEnum = relationalOpEnum;
        this.isAll = isAll;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprRelationalOpAllAnyNode.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        return this.forge;
    }

    public boolean isConstantResult() {
        return false;
    }

    public boolean isAll() {
        return this.isAll;
    }

    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        EPType coercionType;
        if (this.getChildNodes().length < 1) {
            throw new IllegalStateException("Group relational op node must have 1 or more parameters");
        }
        EPType typeOne = JavaClassHelper.getBoxedType(this.getChildNodes()[0].getForge().getEvaluationType());
        ExprNodeUtilityValidate.validateLHSTypeAnyAllSomeIn(typeOne);
        ArrayList<EPType> comparedTypes = new ArrayList<EPType>();
        comparedTypes.add(typeOne);
        boolean hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            EPType propType = this.getChildNodes()[i + 1].getForge().getEvaluationType();
            if (propType == null || propType == EPTypeNull.INSTANCE) {
                comparedTypes.add(EPTypeNull.INSTANCE);
                continue;
            }
            EPTypeClass propClass = (EPTypeClass)propType;
            if (propClass.getType().isArray()) {
                hasCollectionOrArray = true;
                if (propClass.getType().getComponentType() == Object.class) continue;
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType(propClass);
                comparedTypes.add(componentType);
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propClass, Collection.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propClass, Map.class)) {
                hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new EPType[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        if (coercionType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Implicit conversion from null-type to numeric or string is not allowed");
        }
        EPTypeClass coercionClass = (EPTypeClass)coercionType;
        if (coercionClass.getType() != String.class && !JavaClassHelper.isNumeric(coercionClass)) {
            throw new ExprValidationException("Implicit conversion from datatype '" + coercionClass + "' to numeric is not allowed");
        }
        RelationalOpEnum.Computer computer = this.relationalOpEnum.getComputer(coercionClass, coercionClass, coercionClass);
        this.forge = new ExprRelationalOpAllAnyNodeForge(this, computer, hasCollectionOrArray);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        writer.append(this.relationalOpEnum.getExpressionText());
        if (this.isAll) {
            writer.append("all");
        } else {
            writer.append("any");
        }
        writer.append("(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().length - 1; ++i) {
            writer.append(delimiter);
            this.getChildNodes()[i + 1].toEPL(writer, this.getPrecedence(), flags);
            delimiter = ",";
        }
        writer.append(")");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRelationalOpAllAnyNode)) {
            return false;
        }
        ExprRelationalOpAllAnyNode other = (ExprRelationalOpAllAnyNode)node;
        return other.relationalOpEnum == this.relationalOpEnum && other.isAll == this.isAll;
    }
}

