/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpNodeForge;

public class ExprRelationalOpNodeForgeEval
implements ExprEvaluator {
    private final ExprRelationalOpNodeForge forge;
    private final ExprEvaluator left;
    private final ExprEvaluator right;

    public ExprRelationalOpNodeForgeEval(ExprRelationalOpNodeForge forge, ExprEvaluator left, ExprEvaluator right) {
        this.forge = forge;
        this.left = left;
        this.right = right;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object lvalue = this.left.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (lvalue == null) {
            return null;
        }
        Object rvalue = this.right.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (rvalue == null) {
            return null;
        }
        return this.forge.getComputer().compare(lvalue, rvalue);
    }

    public static CodegenExpression codegen(ExprRelationalOpNodeForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprForge lhs = forge.getForgeRenderable().getChildNodes()[0].getForge();
        ExprForge rhs = forge.getForgeRenderable().getChildNodes()[1].getForge();
        EPType lhsType = lhs.getEvaluationType();
        if (lhsType == null || lhsType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPType rhsType = rhs.getEvaluationType();
        if (rhsType == null || rhsType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass lhsTypeClass = (EPTypeClass)lhsType;
        EPTypeClass rhsTypeClass = (EPTypeClass)rhsType;
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), ExprRelationalOpNodeForgeEval.class, (CodegenScope)codegenClassScope);
        CodegenBlock block = methodNode.getBlock().declareVar(lhsTypeClass, "left", lhs.evaluateCodegen(lhsTypeClass, methodNode, exprSymbol, codegenClassScope));
        if (!lhsTypeClass.getType().isPrimitive()) {
            block.ifRefNullReturnNull("left");
        }
        block.declareVar(rhsTypeClass, "right", rhs.evaluateCodegen(rhsTypeClass, methodNode, exprSymbol, codegenClassScope));
        if (!rhsTypeClass.getType().isPrimitive()) {
            block.ifRefNullReturnNull("right");
        }
        block.methodReturn(forge.getComputer().codegen(CodegenExpressionBuilder.ref("left"), lhsTypeClass, CodegenExpressionBuilder.ref("right"), rhsTypeClass));
        return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
    }
}

