/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.ops;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpNodeForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprRelationalOpNodeImpl
extends ExprNodeBase
implements ExprRelationalOpNode {
    private final RelationalOpEnum relationalOpEnum;
    private transient ExprRelationalOpNodeForge forge;

    public ExprRelationalOpNodeImpl(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprRelationalOpNodeImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public ExprForge getForge() {
        ExprRelationalOpNodeImpl.checkValidated(this.forge);
        return this.forge;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 parameters");
        }
        ExprForge lhsForge = this.getChildNodes()[0].getForge();
        ExprForge rhsForge = this.getChildNodes()[1].getForge();
        EPTypeClass lhsClass = this.validateStringOrNumeric(lhsForge);
        EPTypeClass rhsClass = this.validateStringOrNumeric(rhsForge);
        if (lhsClass.getType() != String.class || rhsClass.getType() != String.class) {
            if (!JavaClassHelper.isNumeric(lhsClass)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + lhsClass + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(rhsClass)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + rhsClass + "' to numeric is not allowed");
            }
        }
        EPTypeClass compareType = JavaClassHelper.getCompareToCoercionType(lhsClass, rhsClass);
        RelationalOpEnum.Computer computer = this.relationalOpEnum.getComputer(compareType, lhsClass, rhsClass);
        this.forge = new ExprRelationalOpNodeForge(this, computer);
        return null;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        this.getChildNodes()[0].toEPL(writer, this.getPrecedence(), flags);
        writer.append(this.relationalOpEnum.getExpressionText());
        this.getChildNodes()[1].toEPL(writer, this.getPrecedence(), flags);
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.RELATIONAL_BETWEEN_IN;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprRelationalOpNodeImpl)) {
            return false;
        }
        ExprRelationalOpNodeImpl other = (ExprRelationalOpNodeImpl)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }

    private EPTypeClass validateStringOrNumeric(ExprForge forge) throws ExprValidationException {
        EPType type = forge.getEvaluationType();
        if (type == null || type == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Null-type value is not allow for relational operator");
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        if (typeClass.getType() == String.class) {
            return typeClass;
        }
        return JavaClassHelper.getBoxedType(ExprNodeUtilityValidate.validateReturnsNumeric(forge));
    }
}

