/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.prev;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategy;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStateRandomAccess;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprPreviousMatchRecognizeNode
extends ExprNodeBase
implements ExprForge,
ExprEvaluator {
    private EPType resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private int assignedIndex;
    private CodegenFieldName previousStrategyFieldName;

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().length != 2) {
            throw new ExprValidationException("Match-Recognize Previous expression must have 2 parameters");
        }
        if (!(this.getChildNodes()[0] instanceof ExprIdentNode)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an property identifier as the first parameter");
        }
        if (!this.getChildNodes()[1].getForge().getForgeConstantType().isCompileTimeConstant() || !JavaClassHelper.isNumericNonFP(this.getChildNodes()[1].getForge().getEvaluationType())) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        ExprNode constantNode = this.getChildNodes()[1];
        Object value = constantNode.getForge().getExprEvaluator().evaluate(null, false, null);
        if (!(value instanceof Number)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        this.constantIndexNumber = ((Number)value).intValue();
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes()[0];
        this.streamNumber = identNode.getStreamId();
        ExprForge forge = this.getChildNodes()[0].getForge();
        this.resultType = forge.getEvaluationType();
        this.previousStrategyFieldName = validationContext.getMemberNames().previousMatchrecognizeStrategy();
        return null;
    }

    @Override
    public ExprForgeConstantType getForgeConstantType() {
        return ExprForgeConstantType.NONCONST;
    }

    @Override
    public EPType getEvaluationType() {
        return this.resultType;
    }

    @Override
    public ExprForge getForge() {
        return this;
    }

    @Override
    public ExprNode getForgeRenderable() {
        return this;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public Integer getConstantIndexNumber() {
        if (this.constantIndexNumber == null) {
            ExprNode constantNode = this.getChildNodes()[1];
            Object value = constantNode.getForge().getExprEvaluator().evaluate(null, false, null);
            this.constantIndexNumber = ((Number)value).intValue();
        }
        return this.constantIndexNumber;
    }

    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    @Override
    public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope parent, ExprForgeCodegenSymbol symbols, CodegenClassScope classScope) {
        if (this.resultType == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenMethod method = parent.makeChild((EPTypeClass)this.resultType, this.getClass(), (CodegenScope)classScope);
        CodegenExpressionRef eps = symbols.getAddEPS(method);
        CodegenExpressionField strategy = classScope.getPackageScope().addOrGetFieldWellKnown(this.previousStrategyFieldName, RowRecogPreviousStrategy.EPTYPE);
        CodegenMethod innerEval = CodegenLegoMethodExpression.codegenExpression(this.getChildNodes()[0].getForge(), method, classScope);
        method.getBlock().declareVar(RowRecogStateRandomAccess.EPTYPE, "access", CodegenExpressionBuilder.exprDotMethod(strategy, "getAccess", symbols.getAddExprEvalCtx(method))).declareVar(EventBean.EPTYPE, "substituteEvent", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("access"), "getPreviousEvent", CodegenExpressionBuilder.constant(this.assignedIndex))).ifRefNullReturnNull("substituteEvent").declareVar(EventBean.EPTYPE, "originalEvent", CodegenExpressionBuilder.arrayAtIndex(eps, CodegenExpressionBuilder.constant(this.streamNumber))).assignArrayElement(eps, CodegenExpressionBuilder.constant(this.streamNumber), (CodegenExpression)CodegenExpressionBuilder.ref("substituteEvent")).declareVar((EPTypeClass)this.resultType, "evalResult", (CodegenExpression)CodegenExpressionBuilder.localMethod(innerEval, eps, symbols.getAddIsNewData(method), symbols.getAddExprEvalCtx(method))).assignArrayElement(eps, CodegenExpressionBuilder.constant(this.streamNumber), (CodegenExpression)CodegenExpressionBuilder.ref("originalEvent")).methodReturn(CodegenExpressionBuilder.ref("evalResult"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        writer.append("prev(");
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM, flags);
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprPreviousMatchRecognizeNode;
    }

    public void setAssignedIndex(int assignedIndex) {
        this.assignedIndex = assignedIndex;
    }
}

