/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.abacus;

import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Calendar;
import java.util.Date;

public class TimeAbacusMilliseconds
implements TimeAbacus {
    public static final TimeAbacusMilliseconds INSTANCE = new TimeAbacusMilliseconds();
    private static final long serialVersionUID = 7634550048792013972L;

    private TimeAbacusMilliseconds() {
    }

    @Override
    public long deltaForSecondsDouble(double seconds) {
        return Math.round(1000.0 * seconds);
    }

    @Override
    public CodegenExpression deltaForSecondsDoubleCodegen(CodegenExpressionRef sec, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.staticMethod(Math.class, "round", CodegenExpressionBuilder.op(CodegenExpressionBuilder.constant(1000.0), "*", sec));
    }

    @Override
    public long deltaForSecondsNumber(Number timeInSeconds) {
        if (JavaClassHelper.isFloatingPointNumber(timeInSeconds)) {
            return this.deltaForSecondsDouble(timeInSeconds.doubleValue());
        }
        return 1000L * timeInSeconds.longValue();
    }

    @Override
    public long calendarSet(long fromTime, Calendar cal) {
        cal.setTimeInMillis(fromTime);
        return 0L;
    }

    @Override
    public CodegenExpression calendarSetCodegen(CodegenExpression startLong, CodegenExpression cal, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethodBuild(codegenMethodScope.makeChild(EPTypePremade.LONGPRIMITIVE.getEPType(), TimeAbacusMilliseconds.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LONGPRIMITIVE.getEPType(), "fromTime").addParam(EPTypePremade.CALENDAR.getEPType(), "cal").getBlock().expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.ref("fromTime"))).methodReturn(CodegenExpressionBuilder.constant(0))).pass(startLong).pass(cal).call();
    }

    @Override
    public long calendarGet(Calendar cal, long remainder) {
        return cal.getTimeInMillis();
    }

    @Override
    public long getOneSecond() {
        return 1000L;
    }

    @Override
    public Date toDate(long ts) {
        return new Date(ts);
    }

    @Override
    public CodegenExpression toDateCodegen(CodegenExpression ts) {
        return CodegenExpressionBuilder.newInstance(EPTypePremade.DATE.getEPType(), ts);
    }

    @Override
    public CodegenExpression calendarGetCodegen(CodegenExpression cal, CodegenExpression startRemainder, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.exprDotMethod(cal, "getTimeInMillis", new CodegenExpression[0]);
    }
}

