/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.eval;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdder;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeConstGivenDeltaEval;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodUtil;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriodForge;
import com.espertech.esper.common.internal.schedule.TimeProvider;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TimePeriodComputeNCGivenTPNonCalEval
implements TimePeriodCompute {
    public static final EPTypeClass EPTYPE = new EPTypeClass(TimePeriodComputeNCGivenTPNonCalEval.class);
    private ExprEvaluator[] evaluators;
    private TimePeriodAdder[] adders;
    private TimeAbacus timeAbacus;

    public TimePeriodComputeNCGivenTPNonCalEval() {
    }

    public TimePeriodComputeNCGivenTPNonCalEval(ExprEvaluator[] evaluators, TimePeriodAdder[] adders, TimeAbacus timeAbacus) {
        this.evaluators = evaluators;
        this.adders = adders;
        this.timeAbacus = timeAbacus;
    }

    public void setEvaluators(ExprEvaluator[] evaluators) {
        this.evaluators = evaluators;
    }

    public void setAdders(TimePeriodAdder[] adders) {
        this.adders = adders;
    }

    public void setTimeAbacus(TimeAbacus timeAbacus) {
        this.timeAbacus = timeAbacus;
    }

    @Override
    public long deltaAdd(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.evaluate(eventsPerStream, isNewData, context);
    }

    @Override
    public long deltaSubtract(long currentTime, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.evaluate(eventsPerStream, isNewData, context);
    }

    @Override
    public long deltaUseRuntimeTime(EventBean[] eventsPerStream, ExprEvaluatorContext context, TimeProvider timeProvider) {
        return this.evaluate(eventsPerStream, true, context);
    }

    @Override
    public TimePeriodDeltaResult deltaAddWReference(long current, long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        long timeDelta = this.evaluate(eventsPerStream, isNewData, context);
        return new TimePeriodDeltaResult(TimePeriodUtil.deltaAddWReference(current, reference, timeDelta), reference);
    }

    @Override
    public TimePeriodProvide getNonVariableProvide(ExprEvaluatorContext context) {
        long delta = this.evaluate(null, true, context);
        return new TimePeriodComputeConstGivenDeltaEval(delta);
    }

    private long evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        double seconds = 0.0;
        for (int i = 0; i < this.adders.length; ++i) {
            Double result = this.eval(this.evaluators[i], eventsPerStream, isNewData, context);
            if (result == null) {
                throw ExprTimePeriodForge.makeTimePeriodParamNullException("Received null value evaluating time period");
            }
            seconds += this.adders[i].compute(result);
        }
        return this.timeAbacus.deltaForSecondsDouble(seconds);
    }

    private Double eval(ExprEvaluator expr, EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = expr.evaluate(events, isNewData, exprEvaluatorContext);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((Number)value).doubleValue();
        }
        return ((Number)value).doubleValue();
    }
}

