/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.expression.time.node;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderableFlags;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdder;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderDay;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderHour;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderMSec;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderMinute;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderMonth;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderSecond;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderUSec;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderWeek;
import com.espertech.esper.common.internal.epl.expression.time.adder.TimePeriodAdderYear;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodEval;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriod;
import com.espertech.esper.common.internal.epl.expression.time.node.ExprTimePeriodForge;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayDeque;

public class ExprTimePeriodImpl
extends ExprNodeBase
implements ExprTimePeriod,
TimePeriodEval {
    private final boolean hasYear;
    private final boolean hasMonth;
    private final boolean hasWeek;
    private final boolean hasDay;
    private final boolean hasHour;
    private final boolean hasMinute;
    private final boolean hasSecond;
    private final boolean hasMillisecond;
    private final boolean hasMicrosecond;
    private final TimeAbacus timeAbacus;
    private ExprTimePeriodForge forge;

    public ExprTimePeriodImpl(boolean hasYear, boolean hasMonth, boolean hasWeek, boolean hasDay, boolean hasHour, boolean hasMinute, boolean hasSecond, boolean hasMillisecond, boolean hasMicrosecond, TimeAbacus timeAbacus) {
        this.hasYear = hasYear;
        this.hasMonth = hasMonth;
        this.hasWeek = hasWeek;
        this.hasDay = hasDay;
        this.hasHour = hasHour;
        this.hasMinute = hasMinute;
        this.hasSecond = hasSecond;
        this.hasMillisecond = hasMillisecond;
        this.hasMicrosecond = hasMicrosecond;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ExprForge getForge() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge;
    }

    public ExprEvaluator getExprEvaluator() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.getExprEvaluator();
    }

    @Override
    public TimePeriodEval getTimePeriodEval() {
        return this;
    }

    @Override
    public TimePeriodComputeForge getTimePeriodComputeForge() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        if (this.isConstantResult()) {
            return this.forge.constTimePeriodComputeForge();
        }
        return this.forge.nonconstTimePeriodComputeForge();
    }

    @Override
    public CodegenExpression evaluateGetTimePeriodCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateGetTimePeriodCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public CodegenExpression makeTimePeriodAnonymous(CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass timeClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), TimePeriodEval.EPTYPE);
        CodegenMethod evalMethod = CodegenMethod.makeParentNode(TimePeriod.EPTYPE, this.getClass(), classScope).addParam(ExprForgeCodegenNames.PARAMS);
        timeClass.addMethod("timePeriodEval", evalMethod);
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, true);
        CodegenMethod exprMethod = evalMethod.makeChildWithScope(TimePeriod.EPTYPE, this.getClass(), (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression expression = this.forge.evaluateGetTimePeriodCodegen(exprMethod, exprSymbol, classScope);
        exprSymbol.derivedSymbolsCodegen(evalMethod, exprMethod.getBlock(), classScope);
        exprMethod.getBlock().methodReturn(expression);
        evalMethod.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        return timeClass;
    }

    @Override
    public CodegenExpression evaluateAsSecondsCodegen(CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateAsSecondsCodegen(codegenMethodScope, exprSymbol, codegenClassScope);
    }

    @Override
    public boolean hasVariable() {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.isHasVariable();
    }

    @Override
    public TimePeriod evaluateGetTimePeriod(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateGetTimePeriod(eventsPerStream, newData, context);
    }

    @Override
    public double evaluateAsSeconds(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
        ExprTimePeriodImpl.checkValidated(this.forge);
        return this.forge.evaluateAsSeconds(eventsPerStream, newData, context);
    }

    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }

    @Override
    public boolean isHasDay() {
        return this.hasDay;
    }

    @Override
    public boolean isHasHour() {
        return this.hasHour;
    }

    @Override
    public boolean isHasMinute() {
        return this.hasMinute;
    }

    @Override
    public boolean isHasSecond() {
        return this.hasSecond;
    }

    @Override
    public boolean isHasMillisecond() {
        return this.hasMillisecond;
    }

    @Override
    public boolean isHasMicrosecond() {
        return this.hasMicrosecond;
    }

    @Override
    public boolean isHasYear() {
        return this.hasYear;
    }

    @Override
    public boolean isHasMonth() {
        return this.hasMonth;
    }

    @Override
    public boolean isHasWeek() {
        return this.hasWeek;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        boolean hasVariables = false;
        for (ExprNode childNode : this.getChildNodes()) {
            hasVariables |= this.validate(childNode);
        }
        ArrayDeque<TimePeriodAdder> list = new ArrayDeque<TimePeriodAdder>();
        if (this.hasYear) {
            list.add(TimePeriodAdderYear.INSTANCE);
        }
        if (this.hasMonth) {
            list.add(TimePeriodAdderMonth.INSTANCE);
        }
        if (this.hasWeek) {
            list.add(TimePeriodAdderWeek.INSTANCE);
        }
        if (this.hasDay) {
            list.add(TimePeriodAdderDay.INSTANCE);
        }
        if (this.hasHour) {
            list.add(TimePeriodAdderHour.INSTANCE);
        }
        if (this.hasMinute) {
            list.add(TimePeriodAdderMinute.INSTANCE);
        }
        if (this.hasSecond) {
            list.add(TimePeriodAdderSecond.INSTANCE);
        }
        if (this.hasMillisecond) {
            list.add(TimePeriodAdderMSec.INSTANCE);
        }
        if (this.hasMicrosecond) {
            list.add(TimePeriodAdderUSec.INSTANCE);
        }
        TimePeriodAdder[] adders = list.toArray(new TimePeriodAdder[list.size()]);
        this.forge = new ExprTimePeriodForge(this, hasVariables, adders);
        return null;
    }

    @Override
    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.getForge().getForgeConstantType().isCompileTimeConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer, ExprNodeRenderableFlags flags) {
        int exprCtr = 0;
        String delimiter = "";
        if (this.hasYear) {
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" years");
            delimiter = " ";
        }
        if (this.hasMonth) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" months");
            delimiter = " ";
        }
        if (this.hasWeek) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" weeks");
            delimiter = " ";
        }
        if (this.hasDay) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" days");
            delimiter = " ";
        }
        if (this.hasHour) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" hours");
            delimiter = " ";
        }
        if (this.hasMinute) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" minutes");
            delimiter = " ";
        }
        if (this.hasSecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" seconds");
            delimiter = " ";
        }
        if (this.hasMillisecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr++].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" milliseconds");
            delimiter = " ";
        }
        if (this.hasMicrosecond) {
            writer.append(delimiter);
            this.getChildNodes()[exprCtr].toEPL(writer, this.getPrecedence(), flags);
            writer.append(" microseconds");
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprTimePeriodImpl)) {
            return false;
        }
        ExprTimePeriodImpl other = (ExprTimePeriodImpl)node;
        if (this.hasYear != other.hasYear) {
            return false;
        }
        if (this.hasMonth != other.hasMonth) {
            return false;
        }
        if (this.hasWeek != other.hasWeek) {
            return false;
        }
        if (this.hasDay != other.hasDay) {
            return false;
        }
        if (this.hasHour != other.hasHour) {
            return false;
        }
        if (this.hasMinute != other.hasMinute) {
            return false;
        }
        if (this.hasSecond != other.hasSecond) {
            return false;
        }
        if (this.hasMillisecond != other.hasMillisecond) {
            return false;
        }
        return this.hasMicrosecond == other.hasMicrosecond;
    }

    @Override
    public TimePeriod timePeriodEval(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateGetTimePeriod(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    private boolean validate(ExprNode expression) throws ExprValidationException {
        if (expression == null) {
            return false;
        }
        EPType returnType = expression.getForge().getEvaluationType();
        ExprNodeUtilityValidate.validateReturnsNumeric(expression.getForge(), () -> "Time period expression requires a numeric parameter type");
        if ((this.hasMonth || this.hasYear) && !JavaClassHelper.isTypeInteger(returnType)) {
            throw new ExprValidationException("Time period expressions with month or year component require integer values, received a " + returnType.getTypeName() + " value");
        }
        return expression instanceof ExprVariableNode;
    }
}

